#ifdef WIN32
#pragma warning(disable:4786)
#pragma warning(disable:4290)
#endif

#include <OpenTracker/input/MyTutorialModule.h>
#include <OpenTracker/core/Context.h>
#include <iostream>


namespace ot {

//------------------------------------------------------------------------------
// In following macro, module registration function named
// "registerModuleMyTutorialModule()"  is defined.
// This would be called from SPLModule class.
//------------------------------------------------------------------------------
OT_MODULE_REGISTER_FUNC(MyTutorialModule){
  OT_MODULE_REGISTRATION_DEFAULT(MyTutorialModule, "MyTutorialConfig" );
}


//------------------------------------------------------------------------------
// FUNCTION: MyTutorialModlue()
//
// Constructor of this class
//------------------------------------------------------------------------------
MyTutorialModule::MyTutorialModule() 
{
  source = NULL;
  sink   = NULL;
}


//------------------------------------------------------------------------------
// FUNCTION: MyTutorialModlue()
//
// Destructor of this class
//------------------------------------------------------------------------------
MyTutorialModule::~MyTutorialModule()
{

}


//------------------------------------------------------------------------------
// FUNCTION: createNode()
//
// This function creates node for "Sink" and "Source".
// Called when NaviTrack finds a name of node in XML file during starting up.
// Note that this implementation does not allow to have multiple nodes.
// Use std::vector to manage multiple nodes.
//------------------------------------------------------------------------------
ot::Node * MyTutorialModule::createNode( const std::string& name,  ot::StringTable& attributes)
{
  if( name.compare("MyTutorialSink") == 0 )
    {
      std::string strName=attributes.get("name");
      std::cout << "MyTutorialModule::createNode(): creating a MyTutorialSink node" << std::endl;
      std::cout << "MyTutorialModule::createNode(): attribute\"name\" is " << strName << std::endl;
      sink =  new MyTutorialSink();
      return sink;
    }
  if(name.compare("MyTutorialSource") == 0 )
    {
      std::string strName=attributes.get("name");
      std::cout << "MyTutorialModule::createNode(): creating a MyTutorialSource node" << std::endl;
      std::cout << "MyTutorialModule::createNode(): attribute\"name\" is " << strName << std::endl;
      source = new MyTutorialSource(strName);
      return source;
    }
  return NULL;
}


//------------------------------------------------------------------------------
// FUNCTION: pushState
//
// This function updates trackerinfo for all sources of this module
//------------------------------------------------------------------------------
void MyTutorialModule::pushEvent()
{
  if(source)
    {
      std::cout << "MyTutorialModule::pushEvent() is called." << std::endl;
      source->event.getPosition()[0] += 0.01;
      source->event.getPosition()[1] += 0.02;
      source->event.getPosition()[2] += 0.03;
      source->event.getOrientation()[0] += 0.01;
      source->event.getOrientation()[1] += 0.02;
      source->event.getOrientation()[2] += 0.03;
      source->event.getOrientation()[3] += 0.04;
      
      source->event.timeStamp();
      source->updateObservers( source->event );
    }
}


//------------------------------------------------------------------------------
// FUNCTION: init()
//
// This function updates trackerinfo for all sources of this module
//------------------------------------------------------------------------------
void MyTutorialModule::init(StringTable& attributes, ConfigNode * localTree)
{
  std::cout << "MyTutorialModule::init() is called." << std::endl;

  std::string strName=attributes.get("name");
  std::cout << "MyTutorialModule::init(): attribute \"name\" is " 
            << strName << std::endl;
}


} // end of "namespace ot"





