#ifndef __MY_TUTORIAL_MODULE_H__
#define __MY_TUTORIAL_MODULE_H__

#include <OpenTracker/OpenTracker.h>
#include <OpenTracker/dllinclude.h>
#include <OpenTracker/input/SPLModules.h>
#include <OpenTracker/input/MyTutorialSink.h>
#include <OpenTracker/input/MyTutorialSource.h>

#include <string>

namespace ot {

class OPENTRACKER_API MyTutorialModule : public Module, public NodeFactory
{
  
 public:
  
  // Constructor and destructor
  MyTutorialModule();
  virtual ~MyTutorialModule();
  
  Node* createNode(const std::string& name,  ot::StringTable& attributes);
  void  pushEvent();
  void  pullEvent() {};
  void  init(StringTable&, ConfigNode *);
  
 private:
  
  MyTutorialSink*   sink;
  MyTutorialSource* source;
  
  friend class  MyTutorialSink;
  friend class  MyTutorialSource;
};

OT_MODULE(MyTutorialModule);


} // end of namespace ot

#endif // __MY_TUTORIAL_MODULE_H__
