#include <OpenTracker/input/MyTutorialSink.h>

#ifdef WIN32
#include <windows.h>
#include <OpenTracker/misc/SPLOT_Win.h>
#endif

#include <iostream>

namespace ot {

  MyTutorialSink::MyTutorialSink()
  {
  }

  MyTutorialSink::~MyTutorialSink()
  {
  }

  void MyTutorialSink::onEventGenerated( Event& event, Node& generator)
  {
    float orientation[4];
    float position[3];

    if (event.hasAttribute("orientation"))
      {
        for  (int i = 0; i < 4; i ++)
          orientation[i]=-event.getOrientation()[i];
      }
    else
      {
	orientation[0]=0.0;
	orientation[1]=1.0;
	orientation[2]=0.0;
	orientation[3]=0.0;
      }
    if(event.hasAttribute("position"))
      for(int i = 0; i < 3; i ++)
        position[i]=event.getPosition()[i];
    else
      {
	position[0]=0.0;
	position[1]=0.0;
	position[2]=0.0;
      }
    std::cout << "MyTutorialSink::onEventGenerated(): pos = ("
              << position[0] << ", " << position[1] << ", " << position[2] << ")"
              << std::endl;
    std::cout << "MyTutorialSink::onEventGenerated(): ori = ("
              << orientation[0] << ", " << orientation[1] << ", " << orientation[2] << ","
              << orientation[3] << ")"  << std::endl;
    
  }
  
} // end of namespace ot
