#ifdef WIN32
#pragma warning(disable:4786)
#pragma warning(disable:4290)
#endif

#include <OpenTracker/input/MyTutorialThreadModule.h>
#include <OpenTracker/core/Context.h>
#include <iostream>


namespace ot {

//------------------------------------------------------------------------------
// In following macro, module registration function named
// "registerModuleMyTutorialThreadModule()"  is defined.
// This would be called from SPLModule class.
//------------------------------------------------------------------------------
OT_MODULE_REGISTER_FUNC(MyTutorialThreadModule){
  OT_MODULE_REGISTRATION_DEFAULT(MyTutorialThreadModule, "MyTutorialThreadConfig" );
}


//------------------------------------------------------------------------------
// FUNCTION: MyTutorialThreadModlue()
//
// Constructor of this class
//------------------------------------------------------------------------------
MyTutorialThreadModule::MyTutorialThreadModule() 
{
  source = NULL;
  sink   = NULL;
}


//------------------------------------------------------------------------------
// FUNCTION: MyTutorialThreadModlue()
//
// Destructor of this class
//------------------------------------------------------------------------------
MyTutorialThreadModule::~MyTutorialThreadModule()
{

}


//------------------------------------------------------------------------------
// FUNCTION: createNode()
//
// This function creates node for "Sink" and "Source".
// Called when NaviTrack finds a name of node in XML file during starting up.
// Note that this implementation does not allow to have multiple nodes.
// Use std::vector to manage multiple nodes.
//------------------------------------------------------------------------------
ot::Node * MyTutorialThreadModule::createNode( const std::string& name,  ot::StringTable& attributes)
{
  if( name.compare("MyTutorialThreadSink") == 0 )
    {
      std::string strName=attributes.get("name");
      std::cout << "MyTutorialThreadModule::createNode(): creating a MyTutorialThreadSink node" << std::endl;
      std::cout << "MyTutorialThreadModule::createNode(): attribute \"name\" is " << strName << std::endl;
      sink =  new MyTutorialThreadSink();
      return sink;
    }
  if(name.compare("MyTutorialThreadSource") == 0 )
    {
      std::string strName=attributes.get("name");
      std::cout << "MyTutorialThreadModule::createNode(): creating a MyTutorialThreadSource node" << std::endl;
      std::cout << "MyTutorialThreadModule::createNode(): attribute \"name\" is " << strName << std::endl;
      source = new MyTutorialThreadSource(strName);
      return source;
    }
  return NULL;
}


//------------------------------------------------------------------------------
// FUNCTION: pushState
//
// This function updates trackerinfo for all sources of this module
//------------------------------------------------------------------------------
void MyTutorialThreadModule::pushEvent()
{
  if(source)
    {
      std::cout << "MyTutorialThreadModule::pushEvent() is called." << std::endl;
      source->event.getPosition()[0] += 0.01;
      source->event.getPosition()[1] += 0.02;
      source->event.getPosition()[2] += 0.03;
      source->event.getOrientation()[0] += 0.01;
      source->event.getOrientation()[1] += 0.02;
      source->event.getOrientation()[2] += 0.03;
      source->event.getOrientation()[3] += 0.04;
      
      source->event.timeStamp();
      source->updateObservers( source->event );
    }
}


//------------------------------------------------------------------------------
// FUNCTION: init()
//
// This function updates trackerinfo for all sources of this module
//------------------------------------------------------------------------------
void MyTutorialThreadModule::init(StringTable& attributes, ConfigNode * localTree)
{
  std::cout << "MyTutorialThreadModule::init() is called." << std::endl;
  ThreadModule::init( attributes, localTree );      
  
  std::string strName=attributes.get("name");
  std::cout << "MyTutorialThreadModule::init(): attribute \"name\" is " 
            << strName << std::endl;
}


//------------------------------------------------------------------------------
// FUNCTION: run()
//
// This function is the main part of the thread.
//------------------------------------------------------------------------------
void MyTutorialThreadModule::run()
{
  std::cout << "MyTutorialThreadModule::run() is called." << std::endl;
  while (stop == 0) {
    sleep(1);
    std::cout << "MyTutorialThreadModule::run(): looping." << std::endl;
  }
}


//------------------------------------------------------------------------------
// FUNCTION: start()
//
// This function is called to start the thread.
//------------------------------------------------------------------------------
void MyTutorialThreadModule::start()
{
  std::cout << "MyTutorialThreadModule::start() is called." << std::endl;
  stop = 0;
  if (isInitialized() && source != NULL)
    ThreadModule::start();
}


//------------------------------------------------------------------------------
// FUNCTION: close()
//
// This function is called to stop the thread.
//------------------------------------------------------------------------------
void MyTutorialThreadModule::close()
{
  std::cout << "MyTutorialThreadModule::close() is called." << std::endl;
  lock();
  stop = 1;
  unlock();
}


} // end of "namespace ot"





