#ifndef __MY_TUTORIAL_THREAD_MODULE_H__
#define __MY_TUTORIAL_THREAD_MODULE_H__

#include <OpenTracker/OpenTracker.h>
#include <OpenTracker/dllinclude.h>
#include <OpenTracker/input/SPLModules.h>
#include <OpenTracker/input/MyTutorialThreadSink.h>
#include <OpenTracker/input/MyTutorialThreadSource.h>

#include <string>

namespace ot {

class OPENTRACKER_API MyTutorialThreadModule : public ThreadModule, public NodeFactory
{
 private:
  int stop;

 protected:
  void run();

 public:
  
  // Constructor and destructor
  MyTutorialThreadModule();
  virtual ~MyTutorialThreadModule();
  
  Node* createNode(const std::string& name,  ot::StringTable& attributes);
  void  pushEvent();
  void  pullEvent() {};
  void  init(StringTable&, ConfigNode *);

  virtual void  start();
  virtual void  close();
  
 private:
  
  MyTutorialThreadSink*   sink;
  MyTutorialThreadSource* source;
  
  friend class  MyTutorialThreadSink;
  friend class  MyTutorialThreadSource;
};

OT_MODULE(MyTutorialThreadModule);


} // end of namespace ot

#endif // __MY_TUTORIAL_THREAD_MODULE_H__
