<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:dcm="http://docbook.org/ns/docbook" xmlns:fn="http://www.w3.org/2005/xpath-functions">
<xsl:output method="xml" indent="yes"/>


<xsl:template match="/">
  <profile>
    <xsl:call-template name="process_module_table">
      <xsl:with-param name="module_table_node" select="//dcm:title[text() = 'MR Image IOD Module Table']/../dcm:table" />
    </xsl:call-template>
  </profile>
</xsl:template>


<xsl:template name="process_module_table">
  <xsl:param name="module_table_node" required="yes"/>
  <xsl:for-each select="$module_table_node/dcm:tbody/dcm:tr">
    <module>
      <xsl:choose>
        <xsl:when test="count(dcm:td)=3">
          <xsl:attribute name="name"><xsl:value-of select="dcm:td[1]/dcm:para"/></xsl:attribute>
          <xsl:attribute name="usage"><xsl:value-of select="dcm:td[3]/dcm:para"/></xsl:attribute>
          <xsl:call-template name="process_module_attribute_table">
              <xsl:with-param name="module_section_label" select="dcm:td[2]/dcm:para/dcm:xref/@linkend"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="name"><xsl:value-of select="dcm:td[2]/dcm:para"/></xsl:attribute>
          <xsl:attribute name="usage"><xsl:value-of select="dcm:td[4]/dcm:para"/></xsl:attribute>
          <xsl:call-template name="process_module_attribute_table">
            <xsl:with-param name="module_section_label" select="dcm:td[3]/dcm:para/dcm:xref/@linkend"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </module>
  </xsl:for-each>
</xsl:template>


<xsl:template name="process_module_attribute_table">
  <xsl:param name="module_section_label" required="yes" as="xs:string"/>
  <xsl:for-each select="//dcm:section[@xml:id=$module_section_label]/dcm:table/dcm:tbody/dcm:tr">
    <xsl:variable name="curr_nesting_level" select='count(fn:tokenize(./dcm:td[1]/dcm:para,">")) - 1'/>
    <xsl:call-template name="process_attribute_table_row">
      <xsl:with-param name="nesting_level" select="$curr_nesting_level"/>
    </xsl:call-template>
    <xsl:if test="following-sibling::dcm:tr">
      <xsl:variable name="next_nesting_level" select='count(fn:tokenize(./following-sibling::dcm:tr[1]/dcm:td[1]/dcm:para,">")) -1'/>
<!--      <xsl:for-each select="$next_nesting_level to $curr_nesting_level - 1">
        <current_nesting_level> <xsl:value-of select="$curr_nesting_level"/> </current_nesting_level>
        <next_nesting_level> <xsl:value-of select="$next_nesting_level"/> </next_nesting_level>
      </xsl:for-each>-->
    </xsl:if>

  </xsl:for-each>
</xsl:template>


<xsl:template name="process_attribute_table_row">
  <xsl:param name="nesting_level" required="yes"/>
  <xsl:variable name="is_sequence" as="xs:boolean" select='contains(./dcm:td[1]/dcm:para,"Sequence")'/>
  <xsl:choose>
    <xsl:when test="count(./dcm:td)=4">
      <xsl:choose>
        <xsl:when test="$is_sequence">
          <sequence>
            <xsl:attribute name="name"> <xsl:value-of select="./dcm:td[1]/dcm:para"/> </xsl:attribute>
            <xsl:attribute name="tag">  <xsl:value-of select="./dcm:td[2]/dcm:para"/> </xsl:attribute>
            <xsl:attribute name="type"> <xsl:value-of select="./dcm:td[3]/dcm:para"/> </xsl:attribute>
            <xsl:attribute name="todo_nesting_level"> <xsl:value-of select="$nesting_level"/> </xsl:attribute>
          </sequence>
        </xsl:when>
        <xsl:otherwise>
          <element>
            <xsl:attribute name="name"> <xsl:value-of select="./dcm:td[1]/dcm:para"/> </xsl:attribute>
            <xsl:attribute name="tag">  <xsl:value-of select="./dcm:td[2]/dcm:para"/> </xsl:attribute>
            <xsl:attribute name="type"> <xsl:value-of select="./dcm:td[3]/dcm:para"/> </xsl:attribute>
            <xsl:attribute name="todo_nesting_level"> <xsl:value-of select="$nesting_level"/> </xsl:attribute>
            <!--<test><xsl:value-of select="./dcm:td[1]/dcm:para"/>  </test>-->
          </element>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="count(./dcm:td)=2">
      <xsl:variable name="curr_nesting_level" select='count(fn:tokenize(./dcm:td[1]/dcm:para,">")) - 1'/>
      <xsl:call-template name="process_macro_attribute_table">
        <xsl:with-param name="macro_table_id" select="./dcm:td/dcm:para/dcm:emphasis/dcm:xref/@linkend"/>
        <xsl:with-param name="nesting_level" select="$curr_nesting_level"/>
      </xsl:call-template>
    </xsl:when>
  </xsl:choose>
</xsl:template>


<xsl:template name="process_macro_attribute_table">
  <xsl:param name="nesting_level" required="yes"/>
  <xsl:param name="macro_table_id" required="yes" as="xs:string"/>
  <!--<macro>-->
    <!--<xsl:attribute name="nesting_level" select="$nesting_level"/>-->
    <xsl:for-each select="//dcm:table[@xml:id=$macro_table_id]/dcm:tbody/dcm:tr">
      <xsl:call-template name="process_attribute_table_row">
        <xsl:with-param name="nesting_level" select="$nesting_level"/>
      </xsl:call-template>
    </xsl:for-each>
  <!--</macro>-->
</xsl:template>

</xsl:stylesheet>
