/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.WebForm;
import java.io.IOException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SubmitButton
extends Button {
    private boolean _fake;
    private String[] _value = new String[1];
    private final boolean _isImageButton;
    private boolean _pressed;
    private int _x;
    private int _y;

    public String getType() {
        return this.isImageButton() ? "image" : "submit";
    }

    public boolean isImageButton() {
        return this._isImageButton;
    }

    public void click(int x, int y) throws IOException, SAXException {
        if (!this.isImageButton()) {
            throw new IllegalStateException("May only specify positions for an image button");
        }
        this.verifyButtonEnabled();
        if (this.doOnClickEvent()) {
            this.getForm().doFormSubmit(this, x, y);
        }
    }

    protected void doButtonAction() throws IOException, SAXException {
        this.getForm().doFormSubmit(this);
    }

    public String toString() {
        return "Submit with " + this.getName() + "=" + this.getValue();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getValue().hashCode();
    }

    public boolean equals(Object o) {
        return this.getClass().equals(o.getClass()) && this.equals((SubmitButton)o);
    }

    SubmitButton(WebForm form, Node node) {
        super(form, node);
        this._isImageButton = NodeUtils.getNodeAttribute(node, "type").equalsIgnoreCase("image");
    }

    SubmitButton(WebForm form) {
        super(form);
        this._isImageButton = false;
    }

    static SubmitButton createFakeSubmitButton(WebForm form) {
        return new SubmitButton(form, true);
    }

    private SubmitButton(WebForm form, boolean fake) {
        this(form);
        this._fake = fake;
    }

    boolean isFake() {
        return this._fake;
    }

    void setPressed(boolean pressed) {
        this._pressed = pressed;
    }

    void setLocation(int x, int y) {
        this._x = x;
        this._y = y;
    }

    String[] getValues() {
        return this.isDisabled() || !this._pressed ? FormControl.NO_VALUE : this.toArray(this.getValueAttribute());
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this._pressed && !this.isDisabled() && this.getName().length() > 0) {
            if (this.getValueAttribute().length() > 0) {
                processor.addParameter(this.getName(), this.getValueAttribute(), characterSet);
            }
            if (this._isImageButton) {
                processor.addParameter(this.getName() + ".x", Integer.toString(this._x), characterSet);
                processor.addParameter(this.getName() + ".y", Integer.toString(this._y), characterSet);
            }
        }
    }

    private String[] toArray(String value) {
        this._value[0] = value;
        return this._value;
    }

    private boolean equals(SubmitButton button) {
        return this.getName().equals(button.getName()) && (this.getName().length() == 0 || this.getValue().equals(button.getValue()));
    }
}

