/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ClassLibrary
implements Serializable {
    private final Set classes = new TreeSet();
    private final Map classNameToClassMap = new HashMap();
    private boolean defaultLoaders = false;
    private transient List classLoaders = new ArrayList();
    private JavaClassCache cache;

    public ClassLibrary(JavaClassCache cache) {
        this.cache = cache;
    }

    public void add(String fullClassName) {
        this.classes.add(fullClassName);
    }

    public JavaClass getClassByName(String name) {
        return this.cache.getClassByName(name);
    }

    public boolean contains(String fullClassName) {
        if (this.classes.contains(fullClassName)) {
            return true;
        }
        return this.getClass(fullClassName) != null;
    }

    public Class getClass(String fullClassName) {
        Class cachedClass = (Class)this.classNameToClassMap.get(fullClassName);
        if (cachedClass != null) {
            return cachedClass;
        }
        Iterator iterator = this.classLoaders.iterator();
        while (iterator.hasNext()) {
            ClassLoader classLoader = (ClassLoader)iterator.next();
            if (classLoader == null) continue;
            try {
                Class<?> clazz = classLoader.loadClass(fullClassName);
                if (clazz == null) continue;
                this.classNameToClassMap.put(fullClassName, clazz);
                return clazz;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
            }
        }
        return null;
    }

    public Collection all() {
        return Collections.unmodifiableCollection(this.classes);
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void addDefaultLoader() {
        if (!this.defaultLoaders) {
            this.classLoaders.add(this.getClass().getClassLoader());
            this.classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        this.defaultLoaders = true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.classLoaders = new ArrayList();
        if (this.defaultLoaders) {
            this.defaultLoaders = false;
            this.addDefaultLoader();
        }
    }
}

