/*
 * Decompiled with CFR 0.152.
 */
package dart.server;

import dart.server.Container;
import dart.server.Server;
import dart.server.TrackManager;
import dart.server.task.ArchiveTask;
import dart.server.wrap.TaskQueueEntity;
import dart.server.wrap.TaskQueueFinderBase;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.log4j.Logger;
import org.mortbay.http.DigestAuthenticator;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.http.handler.ResourceHandler;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;

public class Project
extends Container {
    static final int DBMajorVersion = 1;
    static final int DBMinorVersion = 2;
    static final String DBVersionString = "1.2";
    static Logger logger = Logger.getLogger(class$dart$server$Project == null ? (class$dart$server$Project = Project.class$("dart.server.Project")) : class$dart$server$Project);
    static Properties statsDefaults = new Properties();
    TrackManager trackManager = null;
    File dataDirectory = null;
    File archiveDirectory = null;
    File resultDirectory = null;
    ArrayList Tasks = new ArrayList();
    Properties stats = new Properties(statsDefaults);
    Properties properties = new Properties();
    HttpServer httpServer = null;
    Scheduler scheduler = null;
    ArrayList Rollups = new ArrayList();
    HashMap lockMap = new HashMap();
    static /* synthetic */ Class class$dart$server$Project;
    static /* synthetic */ Class class$dart$server$Server;
    static /* synthetic */ Class class$dart$server$task$Task;
    static /* synthetic */ Class class$dart$server$task$ScheduledTask;

    public static String getDBVersionString() {
        return DBVersionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Project: " + this.title + "\n");
        buffer.append("Statistics: " + this.stats + "\n");
        buffer.append("Database Version: 1.2\n");
        buffer.append("Table Counts: \n");
        Connection connection = this.database.getConnection();
        String[] Tables = new String[]{"Client", "Submission", "Test", "Result", "Track", "TaskQueue", "CompletedTask"};
        try {
            for (int i = 0; i < Tables.length; ++i) {
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery("select count(*) as c from " + Tables[i]);
                rs.next();
                buffer.append("\t" + Tables[i] + ": " + rs.getInt("c") + "\n");
            }
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to fetch counts", e);
        }
        finally {
            try {
                logger.debug("Closing connection.");
                this.closeConnection(connection);
            }
            catch (Exception e) {}
        }
        buffer.append(this.database.toString() + "\n");
        buffer.append(this.servletManager.toString() + "\n");
        buffer.append(this.trackManager.toString() + "\n");
        return buffer.toString();
    }

    public Properties getStats() {
        return this.stats;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public void setStatistic(String key, String value) {
        this.stats.put(key, value);
    }

    public void incrementStatistic(String key) {
        this.incrementStatistic(key, 1);
    }

    public void incrementStatistic(String key, int i) {
        if (!this.stats.containsKey(key)) {
            logger.debug(this.title + ": Did not find key: " + key + " in statistics, setting to zero");
            this.stats.put(key, "0");
        }
        int v = Integer.parseInt((String)this.stats.get(key)) + i;
        this.stats.put(key, Integer.toString(v));
    }

    public void incrementStatistic(String key, double i) {
        if (!this.stats.containsKey(key)) {
            logger.debug(this.title + ": Did not find key: " + key + " in statistics, setting to zero");
            this.stats.put(key, "0.0");
        }
        double v = Double.parseDouble((String)this.stats.get(key)) + i;
        this.stats.put(key, Double.toString(v));
    }

    public Server getServer() {
        return this.dartServer;
    }

    public void setBaseDirectory(String d) {
        super.setBaseDirectory(d);
        this.dataDirectory = new File(d, "Data");
        this.archiveDirectory = new File(d, "Archive");
        this.resultDirectory = new File(d, "Result");
        if (!this.temporaryDirectory.exists()) {
            this.temporaryDirectory.mkdir();
            new File(this.temporaryDirectory, "Failed").mkdir();
        }
        if (!this.dataDirectory.exists()) {
            this.dataDirectory.mkdir();
        }
        if (!this.archiveDirectory.exists()) {
            this.archiveDirectory.mkdir();
        }
        if (!this.resultDirectory.exists()) {
            this.resultDirectory.mkdir();
        }
    }

    public File getResultDirectory() {
        return this.resultDirectory;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public File getArchiveDirectory() {
        return this.archiveDirectory;
    }

    public Object getLockObject(String key) {
        if (!this.lockMap.containsKey(key)) {
            this.lockMap.put(key, new Object());
        }
        return this.lockMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateProjectRelativeFileForBinary(byte[] b, String suffix) {
        File file = this.dataDirectory;
        synchronized (file) {
            String filename;
            File file2;
            StringBuffer hash = new StringBuffer();
            try {
                MessageDigest algorithm = MessageDigest.getInstance("MD5");
                algorithm.reset();
                algorithm.update(b);
                byte[] digest = algorithm.digest();
                for (int j = 0; j < digest.length; ++j) {
                    String hexChar = Integer.toHexString(0xFF & digest[j]);
                    while (hexChar.length() < 2) {
                        hexChar = '0' + hexChar;
                    }
                    hash.append(hexChar);
                }
            }
            catch (Exception e) {
                logger.error(this.title + ": Failed to generate MD5 hash", e);
            }
            String base = hash.substring(0, 2) + File.separator + hash.substring(2, 4) + File.separator + hash.substring(4, 6) + File.separator + hash.toString();
            int count = -1;
            do {
                filename = count == -1 ? base + suffix : base + "-" + count + suffix;
                ++count;
            } while ((file2 = new File(this.getDataDirectory(), filename)).exists() && (!file2.exists() || file2.length() != (long)b.length));
            file2 = new File(filename);
            return file2;
        }
    }

    public void addTask(String Type2, String Schedule, Properties properties) {
        logger.debug(this.title + ": Adding Task: " + Type2 + " Schedule: " + Schedule + " Properties: " + properties);
        this.Tasks.add(new Object[]{Type2, Schedule, properties});
    }

    public ArrayList getRollups() {
        return this.Rollups;
    }

    public void addRollup(String Type2, String Priority2, Properties properties) {
        logger.debug(this.title + ": Adding Rollup: " + Type2 + " Priority: " + Priority2 + " Properties: " + properties);
        this.Rollups.add(new Object[]{Type2, Priority2, properties});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getDBVersion() throws Exception {
        int Patch;
        int Minor;
        int Major;
        Connection connection = this.database.getConnection();
        Statement statement = connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery("select * from version");
            if (!rs.next()) {
                throw new Exception("Version table did not contain any rows!");
            }
            Major = rs.getInt("Major");
            Minor = rs.getInt("Minor");
            Patch = rs.getInt("Patch");
            logger.debug("getDBVersion found Major: " + Major + " Minor: " + Minor + " Patch: " + Patch);
        }
        finally {
            logger.debug("Closing connection.");
            this.closeConnection(connection);
        }
        return new int[]{Major, Minor, Patch};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyDatabaseVersion() throws Exception {
        Connection connection = this.database.getConnection();
        Statement statement = connection.createStatement();
        try {
            ResultSet tables = connection.getMetaData().getTables(null, null, "%", null);
            boolean FoundVersion = false;
            while (tables.next()) {
                if (!tables.getString("TABLE_NAME").equalsIgnoreCase("version")) continue;
                FoundVersion = true;
            }
            if (!FoundVersion) {
                throw new Exception("Version table does not exist in Database MetaData");
            }
            int Major = -1;
            int Minor = -1;
            int Patch = -1;
            int[] version = this.getDBVersion();
            Major = version[0];
            Minor = version[1];
            Patch = version[2];
            if (Major != 1 || Minor != 2) {
                logger.error("Database version is " + Major + "." + Minor + " expected version is " + DBVersionString);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            logger.debug("Closing connection.");
            this.closeConnection(connection);
        }
        return true;
    }

    void upgradeDatabase(int FromMajor, int FromMinor, int ToMajor, int ToMinor) throws Exception {
        int Major = -1;
        int Minor = -1;
        int Patch = -1;
        logger.info("Upgrade from " + FromMajor + "." + FromMinor + " to " + ToMajor + "." + ToMinor);
        this.executeSQL(new BufferedReader(new InputStreamReader((class$dart$server$Server == null ? (class$dart$server$Server = Project.class$("dart.server.Server")) : class$dart$server$Server).getClassLoader().getResourceAsStream("dart/Resources/Server/DBUpgrade-" + FromMajor + "." + FromMinor + "to" + ToMajor + "." + ToMinor + ".sql"))));
        int[] version = this.getDBVersion();
        Major = version[0];
        Minor = version[1];
        Patch = version[2];
        if (Major != ToMajor || Minor != ToMinor) {
            throw new Exception("Failed to update from " + FromMajor + "." + FromMinor + " to " + ToMajor + "." + ToMinor + " Found version " + Major + "." + Minor + " instead");
        }
        logger.info("DB Upgrade complete");
    }

    public void upgradeDatabase() throws Exception {
        int Major = -1;
        int Minor = -1;
        int Patch = -1;
        int[] version = this.getDBVersion();
        Major = version[0];
        Minor = version[1];
        Patch = version[2];
        logger.debug("upgradeDatabase found Major: " + Major + " Minor: " + Minor + " Patch: " + Patch);
        if (Major == 0 && Minor == 5) {
            this.upgradeDatabase(0, 5, 0, 6);
        }
        version = this.getDBVersion();
        Major = version[0];
        Minor = version[1];
        Patch = version[2];
        if (Major == 0 && Minor == 6) {
            this.upgradeDatabase(0, 6, 1, 0);
        }
        version = this.getDBVersion();
        Major = version[0];
        Minor = version[1];
        Patch = version[2];
        if (Major == 1 && Minor == 0) {
            this.upgradeDatabase(1, 0, 1, 1);
        }
        version = this.getDBVersion();
        Major = version[0];
        Minor = version[1];
        Patch = version[2];
        if (Major == 1 && Minor == 1) {
            this.upgradeDatabase(1, 1, 1, 2);
        }
    }

    public void start(Server server) throws Exception {
        this.dartServer = server;
        this.httpServer = this.dartServer.getHttpServer();
        logger.info(this.title + ": Starting project");
        try {
            logger.debug(this.title + ": Loading statistics");
            File f = new File(this.getBaseDirectory(), "Statistics.txt");
            if (f.exists()) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                this.stats.load(in);
            }
        }
        catch (Exception e) {
            logger.error(this.title + ": Error loading statistics!", e);
            throw e;
        }
        this.incrementStatistic("Startups");
        if (this.commandManager == null) {
            throw new Exception(this.title + ": CommandManager has not been defined, please edit Projects.xml and restart");
        }
        this.commandManager.start(this);
        if (this.database == null) {
            throw new Exception(this.title + ": Database has not been defined, please edit Projects.xml and restart");
        }
        this.database.start(this);
        if (this.trackManager == null) {
            throw new Exception(this.title + ": TrackManager has not been defined, please edit Projects.xml and restart");
        }
        this.trackManager.start(this);
        if (this.messengerManager == null) {
            throw new Exception(this.title + ": MessengerManager has not been defined, please edit Projects.xml and restart");
        }
        this.messengerManager.start(this);
        if (this.listenerManager == null) {
            throw new Exception(this.title + ": ListenerManager has not been defined, please edit Projects.xml and restart");
        }
        this.listenerManager.start(this);
        this.scheduler = this.dartServer.getScheduler();
        if (this.scheduler == null) {
            throw new Exception(this.title + ": Scheduler has not been defined, please edit Projects.xml and restart");
        }
        for (int i = 0; i < this.Tasks.size(); ++i) {
            Object[] o = (Object[])this.Tasks.get(i);
            String Type2 = null;
            String Schedule = null;
            Properties properties = null;
            Class<?> c = null;
            try {
                CronTrigger trigger;
                JobDetail detail;
                o = (Object[])this.Tasks.get(i);
                Type2 = (String)o[0];
                Schedule = (String)o[1];
                properties = (Properties)o[2];
                c = Class.forName(Type2);
                if ((class$dart$server$task$Task == null ? Project.class$("dart.server.task.Task") : class$dart$server$task$Task).isAssignableFrom(c)) {
                    detail = new JobDetail(this.title + ":" + Type2 + ":" + i, this.title, class$dart$server$task$ScheduledTask == null ? Project.class$("dart.server.task.ScheduledTask") : class$dart$server$task$ScheduledTask);
                    detail.getJobDataMap().put((Object)"Project", this);
                    detail.getJobDataMap().put("Type", Type2);
                    detail.getJobDataMap().put((Object)"Properties", properties);
                    trigger = new CronTrigger(this.title + ":" + i, this.title, Schedule);
                    if (properties.containsKey("Description")) {
                        trigger.setDescription(this.title + ": " + properties.get("Description"));
                    } else {
                        trigger.setDescription(this.title + ": " + Type2);
                    }
                } else {
                    logger.error(this.title + ": Class: " + Type2 + " is not a " + (class$dart$server$task$Task == null ? (class$dart$server$task$Task = Project.class$("dart.server.task.Task")) : class$dart$server$task$Task));
                    throw new Exception(this.title + ": Class: " + Type2 + " is not a " + (class$dart$server$task$Task == null ? (class$dart$server$task$Task = Project.class$("dart.server.task.Task")) : class$dart$server$task$Task));
                }
                this.scheduler.scheduleJob(detail, trigger);
                logger.debug(this.title + ": Scheduled task " + Type2);
                continue;
            }
            catch (Exception e) {
                logger.error(this.title + ": TaskManager startup, could not find class: " + Type2 + " please check class name in Project.xml and restart", e);
                throw e;
            }
        }
        try {
            logger.debug(this.title + ": Creating HTTP context with context path /" + this.title + "/*");
            HttpContext httpContext = this.httpServer.getContext("/" + this.title + "/*");
            logger.debug(this.title + ": Setting resource base to " + this.htmlDirectory.getAbsolutePath());
            httpContext.setResourceBase(this.htmlDirectory.getAbsolutePath());
            logger.info(this.title + ": Adding Plugins directory to classpath");
            httpContext.addClassPath(this.pluginsDirectory.toString());
            File[] jars = this.pluginsDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                if (!jars[i].isFile()) continue;
                logger.info(this.title + ": Adding " + jars[i].toString() + " to classpath");
                httpContext.addClassPath(jars[i].toString());
            }
            if (this.servletManager == null) {
                throw new Exception(this.title + ": ServletManager has not been defined, please edit Projects.xml and restart");
            }
            this.servletManager.start(this, httpContext);
            ResourceHandler handler = new ResourceHandler();
            handler.setDirAllowed(true);
            handler.setAcceptRanges(true);
            httpContext.addHandler(handler);
            httpContext.addHandler(new NotFoundHandler());
            DigestAuthenticator authenticator = new DigestAuthenticator();
            httpContext.setAuthenticator(authenticator);
            logger.debug(this.title + ": Creating HTTP context with context path /" + this.title + "/Data/*");
            HttpContext dataContext = this.httpServer.getContext("/" + this.title + "/Data/*");
            logger.debug(this.title + ": Setting resource base to " + this.dataDirectory.getAbsolutePath());
            dataContext.setResourceBase(this.dataDirectory.getAbsolutePath());
            handler = new ResourceHandler();
            handler.setDirAllowed(true);
            handler.setAcceptRanges(true);
            dataContext.addHandler(handler);
        }
        catch (Exception e) {
            logger.error("Failed to create HTTP context", e);
            throw e;
        }
    }

    public void setTrackManager(TrackManager t) {
        this.trackManager = t;
    }

    public TrackManager getTrackManager() {
        return this.trackManager;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTask(String TaskType, Properties properties, int priority) {
        Connection connection = this.getConnection();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String propString = null;
        try {
            properties.store(out, null);
            propString = out.toString().split("\n", 2)[1];
            JaxorContextImpl session = new JaxorContextImpl(connection);
            TaskQueueFinderBase finder = new TaskQueueFinderBase(session);
            TaskQueueEntity task = finder.newInstance();
            task.setPriority(new Integer(priority));
            task.setType(TaskType);
            task.setProperties(propString);
            session.commit();
            logger.debug(this.title + ": Queued: " + TaskType + "\nProperties: " + propString);
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to add Task: " + TaskType + " to queue with priority: " + priority + " properties:\n" + propString, e);
        }
        finally {
            try {
                logger.debug("Closing connection.");
                this.closeConnection(connection);
            }
            catch (Exception e) {}
        }
    }

    public static boolean isLargeDataType(String type) {
        return !type.equals("numeric/integer") && !type.equals("numeric/float") && !type.equals("numeric/double") && !type.equals("text/string") && !type.equals("text/url");
    }

    public void initializeDatabase() {
        File schema = new File(this.baseDirectory, "Schema.sql");
        if (!schema.exists()) {
            logger.error(this.title + ": Schema file: " + schema.getPath() + " does not exist");
            return;
        }
        this.executeSQL(schema);
    }

    public Date parseBuildStamp(String stamp) {
        SimpleDateFormat parse;
        Date date = null;
        try {
            String s = stamp.substring(0, 13) + " -0000";
            parse = new SimpleDateFormat("yyyyMMdd-HHmm Z");
            date = parse.parse(s);
            logger.debug(this.title + ": parsed to " + date);
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (date == null) {
            String[] formats = new String[]{Container.UTCFormat, "MM/dd/yyyy HH:mm:ss"};
            for (int idx = 0; idx < formats.length; ++idx) {
                try {
                    parse = new SimpleDateFormat(formats[idx]);
                    date = parse.parse(stamp);
                    if (date != null) {
                        return date;
                    }
                    continue;
                }
                catch (ParseException pe) {
                    logger.debug("failed to parese " + stamp + "\n" + pe);
                }
            }
        }
        if (date == null) {
            date = Calendar.getInstance().getTime();
            logger.error(this.getTitle() + ": failed to parse BuildStamp " + stamp + " returning 'now' ( " + date + " )");
        }
        return date;
    }

    public static void generateSchema(String DBType, File f) {
        if (f.exists()) {
            logger.error("Error generating schema, file: " + f.getPath() + " exists");
            return;
        }
        try {
            BufferedWriter outTemplate = new BufferedWriter(new FileWriter(f));
            Server.generateSchema(DBType, outTemplate);
        }
        catch (Exception e) {
            logger.error("Failed to generate schema file: " + f.getPath(), e);
        }
    }

    public void shutdown() throws Exception {
        try {
            this.commandManager.shutdown();
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to shutdown CommandManager", e);
        }
        try {
            this.database.shutdown();
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to shutdown Database", e);
        }
    }

    public void dumpProject() throws Exception {
        Properties props = new Properties();
        props.setProperty("ArchiverList", "All");
        props.setProperty("Archiver.All.AgeInDays", "1");
        props.setProperty("Archiver.All.ArchiveLevel", "4");
        ArchiveTask task = new ArchiveTask();
        task.execute(this, props);
    }

    public void refreshResources() {
        if (!this.temporaryDirectory.exists()) {
            this.temporaryDirectory.mkdir();
        }
        if (!this.dataDirectory.exists()) {
            this.dataDirectory.mkdir();
        }
        if (!this.htmlDirectory.exists()) {
            this.htmlDirectory.mkdir();
        }
        if (!this.templatesDirectory.exists()) {
            this.templatesDirectory.mkdir();
        }
        if (!this.pluginsDirectory.exists()) {
            this.pluginsDirectory.mkdir();
        }
        FileObject dest = null;
        FileObject src = null;
        FileObject templates = null;
        URL resourceRootURL = (class$dart$server$Project == null ? (class$dart$server$Project = Project.class$("dart.server.Project")) : class$dart$server$Project).getClassLoader().getResource("dart/Resources/Project/Style.css");
        logger.debug("Default Project resources root:" + resourceRootURL.toString());
        try {
            File localIcons;
            FileSystemManager fsManager = VFS.getManager();
            src = fsManager.resolveFile(resourceRootURL.toString()).getParent();
            File destinationDirectory = new File(this.htmlDirectory, "Resources").getAbsoluteFile();
            dest = fsManager.resolveFile(destinationDirectory.toString());
            FileSelector noTemplates = new FileSelector(){

                public boolean includeFile(FileSelectInfo info) throws Exception {
                    return !info.getFile().getName().getBaseName().equals("Templates") && !info.getFile().getName().getBaseName().equals(".svn");
                }

                public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                    return !info.getFile().getName().getBaseName().equals("Templates") && !info.getFile().getName().getBaseName().equals(".svn");
                }
            };
            AllFileSelector allFiles = new AllFileSelector();
            File defaultDirectory = new File(this.htmlDirectory, "DefaultResources").getAbsoluteFile();
            FileObject defaultDest = fsManager.resolveFile(defaultDirectory.toString());
            if (defaultDirectory.exists()) {
                defaultDest.delete(allFiles);
            }
            logger.debug("Copying Resources to " + defaultDirectory.toString());
            defaultDest.copyFrom(src, noTemplates);
            logger.debug("Copying Resources to " + destinationDirectory.toString());
            dest.copyFrom(src, noTemplates);
            File localDirectory = new File(this.htmlDirectory, "LocalResources").getAbsoluteFile();
            if (!localDirectory.exists()) {
                localDirectory.mkdir();
            }
            if (!(localIcons = new File(localDirectory, "Icons").getAbsoluteFile()).exists()) {
                localIcons.mkdir();
            }
            FileObject local = fsManager.resolveFile(localDirectory.toString());
            logger.debug("Copying " + localDirectory.toString() + " to " + destinationDirectory.toString());
            dest.copyFrom(local, noTemplates);
            templates = dest.getParent().getParent().resolveFile("Templates");
            File defaultTemplates = new File(this.templatesDirectory.getParent(), "DefaultTemplates").getAbsoluteFile();
            FileObject defaultTempl = fsManager.resolveFile(defaultTemplates.toString());
            if (defaultTemplates.exists()) {
                defaultTempl.delete(allFiles);
            }
            logger.debug("Copying Templates to " + defaultTemplates.toString());
            defaultTempl.copyFrom(src.resolveFile("Templates"), allFiles);
            logger.debug("Copying Templates to " + this.templatesDirectory.toString());
            templates.copyFrom(src.resolveFile("Templates"), allFiles);
            File localTemplates = new File(this.templatesDirectory.getParent(), "LocalTemplates").getAbsoluteFile();
            if (!localTemplates.exists()) {
                localTemplates.mkdir();
            }
            FileObject localTempl = fsManager.resolveFile(localTemplates.toString());
            logger.debug("Copying " + localTemplates.toString() + " to " + templates.toString());
            templates.copyFrom(localTempl, allFiles);
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to refresh resources", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createProject(String path, String db, String templateFile) throws Exception {
        Writer outTemplate;
        block13: {
            Template template;
            File dir = new File(path).getAbsoluteFile();
            if (dir.exists()) {
                logger.error("Directory: " + path + " exists, can not create new project");
                throw new Exception("Directory: " + path + " exists, can not create new project");
            }
            String name = dir.getName();
            logger.info("Creating new Project: " + path + " " + name + " " + db);
            outTemplate = null;
            logger.debug("Creating directory " + dir.toString());
            dir.mkdirs();
            Configuration cfg = new Configuration();
            if (templateFile == null) {
                cfg.setClassForTemplateLoading(class$dart$server$Server == null ? (class$dart$server$Server = Project.class$("dart.server.Server")) : class$dart$server$Server, "/");
                template = cfg.getTemplate("dart/Resources/Server/DartDefault.xml");
            } else {
                File f = new File(templateFile);
                cfg.setDirectoryForTemplateLoading(f.getCanonicalFile().getParentFile());
                template = cfg.getTemplate(f.getName());
            }
            outTemplate = new BufferedWriter(new FileWriter(new File(dir, "Project.xml")));
            HashMap<String, String> root = new HashMap<String, String>();
            root.put("ProjectName", name);
            root.put("ProjectDirectory", dir.toString());
            if (db != null) {
                root.put("Type", db.toLowerCase());
            } else {
                root.put("Type", "derby");
            }
            template.process(root, outTemplate);
            outTemplate.flush();
            outTemplate.close();
            template = cfg.getTemplate("dart/Resources/Server/DartDefault.xml");
            outTemplate = new BufferedWriter(new FileWriter(new File(dir, "DefaultProject.xml")));
            template.process(root, outTemplate);
            outTemplate.flush();
            if (db == null) break block13;
            Project.generateSchema(db, new File(dir, "Schema.sql"));
        }
        Object var10_10 = null;
        if (outTemplate == null) return;
        try {
            outTemplate.close();
            return;
        }
        catch (IOException e2) {
            logger.error("Failed to close output stream", e2);
        }
        return;
        {
            catch (Exception e) {
                logger.error("Error creating default project", e);
                Object var10_11 = null;
                if (outTemplate == null) return;
                try {
                    outTemplate.close();
                    return;
                }
                catch (IOException e2) {
                    logger.error("Failed to close output stream", e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (outTemplate == null) throw throwable;
            try {
                outTemplate.close();
                throw throwable;
            }
            catch (IOException e2) {
                logger.error("Failed to close output stream", e2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Project loadProject(String inPath) {
        File path = new File(inPath);
        if (path.isDirectory()) {
            path = new File(path, "Project.xml");
        }
        Container project = null;
        try {
            URL rules = (class$dart$server$Server == null ? (class$dart$server$Server = Project.class$("dart.server.Server")) : class$dart$server$Server).getClassLoader().getResource("dart/Resources/Server/DartObjectCreationRules.xml");
            logger.debug("Found DartObjectCreationRules.xml at: " + rules);
            Digester digester = new Digester();
            digester.setRules(new ExtendedBaseRules());
            digester.addRuleSet(new FromXmlRuleSet(rules));
            logger.info("Processed rules, starting to parse");
            project = (Project)digester.parse(path);
            logger.info("Parsed to create a project");
        }
        catch (Exception e) {
            logger.error("Failed to create project", e);
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(class$dart$server$Server == null ? (class$dart$server$Server = Project.class$("dart.server.Server")) : class$dart$server$Server, "/");
        Writer outTemplate = null;
        Template template = cfg.getTemplate("dart/Resources/Server/DartDefault.xml");
        outTemplate = new BufferedWriter(new FileWriter(new File(project.getBaseDirectory(), "DefaultProject.xml")));
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("ProjectName", project.getTitle());
        root.put("ProjectDirectory", project.getBaseDirectory());
        root.put("Type", "derby");
        template.process(root, outTemplate);
        outTemplate.flush();
        Object var8_9 = null;
        if (outTemplate == null) return project;
        try {
            outTemplate.close();
            return project;
        }
        catch (IOException e2) {
            logger.error("Failed to close output stream", e2);
        }
        return project;
        {
            catch (Exception e) {
                logger.error("Error creating DefaultProject.xml", e);
                Object var8_10 = null;
                if (outTemplate == null) return project;
                try {
                    outTemplate.close();
                    return project;
                }
                catch (IOException e2) {
                    logger.error("Failed to close output stream", e2);
                }
                return project;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (outTemplate == null) throw throwable;
            try {
                outTemplate.close();
                throw throwable;
            }
            catch (IOException e2) {
                logger.error("Failed to close output stream", e2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        statsDefaults.put("Startups", "0");
        statsDefaults.put("Submissions", "0");
        statsDefaults.put("TestsProcessed", "0");
        statsDefaults.put("BinaryResults", "0");
        statsDefaults.put("LastActivity", "none");
    }
}

