/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SimpleHash
extends WrappingTemplateModel
implements TemplateHashModelEx,
Serializable {
    private Map map;
    private boolean putFailed;

    public SimpleHash() {
        this((ObjectWrapper)null);
    }

    public SimpleHash(Map map) {
        this(map, null);
    }

    public SimpleHash(ObjectWrapper wrapper) {
        super(wrapper);
        this.map = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleHash(Map map, ObjectWrapper wrapper) {
        super(wrapper);
        try {
            this.map = this.copyMap(map);
        }
        catch (ConcurrentModificationException cme) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            Map map2 = map;
            synchronized (map2) {
                this.map = this.copyMap(map);
            }
        }
    }

    protected Map copyMap(Map map) {
        if (map instanceof HashMap) {
            return (Map)((HashMap)map).clone();
        }
        if (map instanceof SortedMap) {
            if (map instanceof TreeMap) {
                return (Map)((TreeMap)map).clone();
            }
            return new TreeMap((SortedMap)map);
        }
        return new HashMap(map);
    }

    public void put(String key, Object obj) {
        this.map.put(key, obj);
    }

    public void put(String key, boolean b) {
        this.put(key, b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object result = this.map.get(key);
        if (result instanceof TemplateModel) {
            return (TemplateModel)result;
        }
        TemplateModel tm = this.wrap(result);
        if (!this.putFailed) {
            try {
                this.map.put(key, tm);
            }
            catch (Exception e) {
                this.putFailed = true;
            }
        }
        return tm;
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void putAll(Map m) {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put((String)entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.map.toString();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public TemplateCollectionModel keys() {
        return new SimpleCollection(this.map.keySet(), this.getObjectWrapper());
    }

    public TemplateCollectionModel values() {
        return new SimpleCollection(this.map.values(), this.getObjectWrapper());
    }

    public SimpleHash synchronizedWrapper() {
        return new SynchronizedHash();
    }

    private class SynchronizedHash
    extends SimpleHash {
        private SynchronizedHash() {
        }

        public synchronized boolean isEmpty() {
            return SimpleHash.this.isEmpty();
        }

        public synchronized void put(String key, Object obj) {
            SimpleHash.this.put(key, obj);
        }

        public synchronized TemplateModel get(String key) throws TemplateModelException {
            return SimpleHash.this.get(key);
        }

        public synchronized void remove(String key) {
            SimpleHash.this.remove(key);
        }

        public synchronized int size() {
            return SimpleHash.this.size();
        }

        public synchronized TemplateCollectionModel keys() {
            return SimpleHash.this.keys();
        }

        public synchronized TemplateCollectionModel values() {
            return SimpleHash.this.values();
        }
    }
}

