/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.sql.ResultSet;
import java.util.List;
import net.sourceforge.jaxor.EntityNotFoundException;
import net.sourceforge.jaxor.MetaField;
import net.sourceforge.jaxor.MetaRow;
import net.sourceforge.jaxor.PrimaryKeySet;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.api.Finder;
import net.sourceforge.jaxor.api.JaxorContext;
import net.sourceforge.jaxor.api.ObjectHolder;
import net.sourceforge.jaxor.api.QueryResult;
import net.sourceforge.jaxor.util.ObjectHolderImpl;

public class BaseFinder
implements Finder {
    private final MetaRow _meta;
    private final String _baseQuery;
    private final String _primaryKeyQuery;
    private final JaxorContext _connection;

    public BaseFinder(MetaRow row, JaxorContext conn) {
        this._meta = row;
        this._baseQuery = this.constructBaseQuery();
        this._primaryKeyQuery = this.constructPrimaryKeyClause();
        this._connection = conn;
    }

    public String getBaseQuerySQL() {
        return this._baseQuery;
    }

    public MetaRow getMetaRow() {
        return this._meta;
    }

    public EntityInterface newInstance() {
        return this._connection.createEntity(this._meta);
    }

    private String constructBaseQuery() {
        List columns = this._meta.getColumns();
        String sql = "SELECT ";
        String table = this._meta.getTableName();
        int i = 0;
        while (i < columns.size()) {
            if (i > 0) {
                sql = sql + ", ";
            }
            MetaField column = (MetaField)columns.get(i);
            sql = sql + table + "." + column.getColumn();
            ++i;
        }
        sql = sql + " FROM " + table + " ";
        return sql;
    }

    private String constructPrimaryKeyClause() {
        List columns = this._meta.getPrimaryKey();
        String sql = "WHERE ";
        int i = 0;
        while (i < columns.size()) {
            if (i > 0) {
                sql = sql + " AND ";
            }
            MetaField column = (MetaField)columns.get(i);
            sql = sql + column.getColumn() + "= ?";
            ++i;
        }
        return sql;
    }

    public List selectAll() {
        return this.query(this.getBaseQuerySQL()).list();
    }

    public EntityInterface selectByPrimaryKey(QueryParams params, boolean useProxy) {
        EntityInterface entity = this.findInCache(params);
        if (entity == null) {
            QueryResult r = this.find(this._primaryKeyQuery, params);
            if (useProxy) {
                return r.entityProxy();
            }
            return r.entity();
        }
        return entity;
    }

    private EntityInterface findInCache(QueryParams params) {
        Class _implClass = this._meta.getImplClass();
        ObjectHolder[] fields = new ObjectHolder[params.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = new ObjectHolderImpl(params.getValue(i));
            ++i;
        }
        return this.getContext().getCache().getFromCache(_implClass, new PrimaryKeySet(fields));
    }

    public boolean entityExists(QueryParams ps) {
        try {
            this.selectByPrimaryKey(ps, false);
            return true;
        }
        catch (EntityNotFoundException notFound) {
            return false;
        }
    }

    public EntityInterface load(ResultSet rs) {
        JaxorContext conn = this.getContext();
        EntityInterface entity = conn.load(rs, this._meta);
        entity.setMetaRow(this._meta);
        return entity;
    }

    public QueryResult query(String sql, QueryParams args) {
        return this.getContext().query(sql, args, this._meta);
    }

    public QueryResult query(String sql) {
        return this.getContext().query(sql, this._meta);
    }

    public QueryResult find(String whereClause, QueryParams p) {
        return this.query(this.getBaseQuerySQL() + whereClause, p);
    }

    public QueryResult find(String whereClause) {
        return this.query(this.getBaseQuerySQL() + whereClause, new QueryParams());
    }

    private JaxorContext getContext() {
        return this._connection;
    }

    public void registerNew(EntityInterface entity) {
        entity.setMetaRow(this._meta);
        this.getContext().registerNew(entity);
    }
}

