/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jaxor.PrimaryKeySet;
import net.sourceforge.jaxor.SqlAdapter;
import net.sourceforge.jaxor.api.FieldAdapter;
import net.sourceforge.jaxor.api.FieldLifeCycleListener;
import net.sourceforge.jaxor.api.JaxorContext;
import net.sourceforge.jaxor.api.ValueChangeListener;
import net.sourceforge.jaxor.util.ForeignFieldLazyLoader;
import net.sourceforge.jaxor.util.SystemException;

public class EntityRow
implements Serializable {
    private FieldAdapter[] _list = new FieldAdapter[0];
    private final List _foreignFields = new ArrayList();
    private final String _table;
    private PrimaryKeySet _pkset = new PrimaryKeySet(new FieldAdapter[0]);
    private List _updateMatchValues;
    private JaxorContext _context;

    public EntityRow(String table) {
        this._table = table;
    }

    public void setJaxorContext(JaxorContext context) {
        this._context = context;
    }

    public JaxorContext getJaxorContext() {
        return this._context;
    }

    public void setFields(FieldAdapter[] fields) {
        this._list = fields;
    }

    public FieldAdapter[] getList() {
        return this._list;
    }

    public void setPrimaryKey(PrimaryKeySet primaryKey) {
        this._pkset = primaryKey;
    }

    public void validate() {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter fieldAdapter = this._list[i];
            fieldAdapter.validate();
            ++i;
        }
    }

    public void registerLoad(ValueChangeListener listener) {
        this.initUpdateMatchValues();
        this.register(listener);
    }

    public void register(ValueChangeListener listener) {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter fieldAdapter = this._list[i];
            fieldAdapter.addChangeListener(listener);
            ++i;
        }
    }

    public void unregisterListener(ValueChangeListener listener) {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter adapter = this._list[i];
            adapter.removeChangeListener(listener);
            ++i;
        }
    }

    public String getTable() {
        return this._table;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this._table);
        int i = 0;
        while (i < this._list.length) {
            buffer.append("\n");
            FieldAdapter entityField = this._list[i];
            buffer.append(entityField.toString());
            ++i;
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this._table.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityRow) {
            return this.equals((EntityRow)obj);
        }
        return false;
    }

    public int size() {
        return this._list.length;
    }

    public boolean equals(EntityRow otherRow) {
        if (this == otherRow) {
            return true;
        }
        if (this.size() != otherRow.size()) {
            return false;
        }
        if (!this.getTable().equals(otherRow.getTable())) {
            return false;
        }
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter entityField = this._list[i];
            if (!entityField.equals(otherRow.getField(entityField.getName()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public FieldAdapter getField(String name) {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter entityField = this._list[i];
            if (entityField.getName().equals(name)) {
                return entityField;
            }
            ++i;
        }
        return null;
    }

    public Object[] getAllValues() {
        Object[] vals = new Object[this.size()];
        int count = 0;
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter adapter = this._list[i];
            vals[count] = adapter.getMappedSqlObject();
            ++count;
            ++i;
        }
        return vals;
    }

    public PrimaryKeySet getPrimaryKey() {
        return this._pkset;
    }

    public List getUpdateMatchValues() {
        if (this._updateMatchValues == null) {
            this.initUpdateMatchValues();
        }
        return this._updateMatchValues;
    }

    private void initUpdateMatchValues() {
        this._updateMatchValues = new ArrayList();
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter adapter = this._list[i];
            if (adapter.isMatchOnUpdate()) {
                SqlAdapter.MatchUpdate matchUpdate = new SqlAdapter.MatchUpdate();
                matchUpdate.mapper = adapter;
                matchUpdate.value = matchUpdate.mapper.getMappedSqlObject();
                this._updateMatchValues.add(matchUpdate);
            }
            ++i;
        }
    }

    public void load(ResultSet rs) throws SQLException {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter adapter = this._list[i];
            adapter.setValueFromResultSet(rs);
            adapter.validateLoad();
            ++i;
        }
    }

    public void notifyFieldsOfInsert(JaxorContext context) {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter fieldAdapter = this._list[i];
            if (fieldAdapter instanceof FieldLifeCycleListener) {
                ((FieldLifeCycleListener)((Object)fieldAdapter)).beforeInsert(context);
            }
            ++i;
        }
    }

    public void notifyFieldsOfUpdate(JaxorContext context) {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter fieldAdapter = this._list[i];
            if (fieldAdapter instanceof FieldLifeCycleListener) {
                ((FieldLifeCycleListener)((Object)fieldAdapter)).beforeUpdate(context);
            }
            ++i;
        }
    }

    public void notifyFieldsOfDelete(JaxorContext context) {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter fieldAdapter = this._list[i];
            if (fieldAdapter instanceof FieldLifeCycleListener) {
                ((FieldLifeCycleListener)((Object)fieldAdapter)).beforeDelete(context);
            }
            ++i;
        }
    }

    public List getForeignFields() {
        return this._foreignFields;
    }

    public void addForeignField(ForeignFieldLazyLoader foreignField) {
        this._foreignFields.add(foreignField);
    }

    public Object getPropertyValue(String propertyName) {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter fieldAdapter = this._list[i];
            if (fieldAdapter.getMetaField().getProperty().equals(propertyName)) {
                return fieldAdapter.getValue();
            }
            ++i;
        }
        throw new SystemException("Failed to Find property: " + propertyName);
    }

    public void setPropertyValue(String property, Object value) {
        int i = 0;
        while (i < this._list.length) {
            FieldAdapter fieldAdapter = this._list[i];
            if (fieldAdapter.getMetaField().getProperty().equals(property)) {
                fieldAdapter.setValue(value);
                return;
            }
            ++i;
        }
        throw new SystemException("Failed to Find property: " + property);
    }
}

