/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import net.sourceforge.jaxor.LazyLoader;

public class LazyProxy
implements InvocationHandler {
    private final LazyLoader _loader;

    public static Object create(LazyLoader loader, Class interfaceClass) {
        HashSet allInterfaces = new HashSet();
        ClassLoader classLoader = interfaceClass.getClassLoader();
        do {
            allInterfaces.addAll(Arrays.asList(interfaceClass.getInterfaces()));
        } while ((interfaceClass = interfaceClass.getSuperclass()) != null);
        Class[] interfaces = allInterfaces.toArray(new Class[allInterfaces.size()]);
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new LazyProxy(loader));
    }

    private LazyProxy(LazyLoader _loader) {
        this._loader = _loader;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this._loader.getValue(), args);
        }
        catch (InvocationTargetException targetExc) {
            throw targetExc.getTargetException();
        }
    }
}

