/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import net.sourceforge.jaxor.generator.MappingMetaData;
import net.sourceforge.jaxor.generator.Sql2JavaMapping;
import net.sourceforge.jaxor.parser.CodeTemplate;
import net.sourceforge.jaxor.parser.Jaxor;
import net.sourceforge.jaxor.util.SystemException;
import org.apache.regexp.RESyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;

public class MappingGeneratorTask
extends Task
implements LogSystem {
    private Sql2JavaMapping mapping = new Sql2JavaMapping();
    private String driver;
    private String url;
    private String user;
    private String password;
    private String schema;
    private String destDir;
    private String catalog;
    private String packageName;
    private String mappingProperties;
    private String tableRegExp;
    private boolean verbose;
    private int _logLevel = 2;
    public static final String ALL_TABLE_REGEXP = ".+";

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getMappingProperties() {
        return this.mappingProperties;
    }

    public void setMappingProperties(String mappingProperties) {
        this.mappingProperties = mappingProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Connection connection = null;
        ResultSet tables = null;
        try {
            try {
                connection = this.estabilishConnection();
                this.log(MessageFormat.format("reversing schema {0} from jdbc url {1}", this.getSchema(), this.getUrl()));
                this.registerMappings();
                if (this.getTableRegExp() != ALL_TABLE_REGEXP) {
                    this.log("only tables matching '" + this.getTableRegExp() + "' will be processed");
                }
                MappingMetaData mappingMeta = null;
                try {
                    mappingMeta = new MappingMetaData(connection, this.getCatalog(), this.getSchema(), this.getMapping(), this.getTableRegExp()){

                        protected void logUnknownDataType(int dataType, String dataName, String name) {
                            this.log("warning: unknown sql data type " + dataType + "(" + dataName + ") column: " + name);
                        }

                        protected void log(String msg) {
                            MappingGeneratorTask.this.log(msg);
                        }
                    };
                }
                catch (RESyntaxException e) {
                    throw new BuildException(this.tableRegExp + " is not a valid regular expression: " + e.getMessage());
                }
                Jaxor[] jaxors = mappingMeta.getMapped();
                int i = 0;
                while (i < jaxors.length) {
                    Jaxor jaxor = jaxors[i];
                    File destFile = new File(this.getDestDir() + File.separator + jaxor.getEntity().getJavaName() + ".jaxor");
                    this.log("Generating mapping file " + destFile);
                    jaxor.setPackage(this.getPackageName());
                    VelocityContext context = new VelocityContext();
                    context.put("jaxor", jaxor);
                    context.put("now", new Date());
                    CodeTemplate template = new CodeTemplate(this, context);
                    template.write("jaxor.vm", destFile);
                    ++i;
                }
            }
            catch (SystemException e) {
                throw new BuildException(e.getMessage());
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (tables != null) {
                    tables.close();
                }
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ignored) {}
        if (tables != null) {
            tables.close();
        }
        if (connection == null) return;
        connection.close();
        return;
    }

    private Sql2JavaMapping getMapping() {
        return this.mapping;
    }

    private void dafaultTableRegexp() {
        this.tableRegExp = ALL_TABLE_REGEXP;
    }

    private void registerMappings() throws SystemException {
        if (this.getMappingProperties() == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            FileInputStream inStream = new FileInputStream(this.getMappingProperties());
            properties.load(inStream);
            inStream.close();
        }
        catch (IOException e) {
            throw new SystemException("error opening/reading from file " + this.getMappingProperties());
        }
        if (((Hashtable)properties).size() > 0) {
            this.log("read additional mappings from file '" + this.getMappingProperties() + "'");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String typeToMap = (String)enumeration.nextElement();
            String typeMappedTo = properties.getProperty(typeToMap);
            String msg = MessageFormat.format("registering mapping from <{0}> to <{1}>", typeToMap, typeMappedTo);
            this.log(msg);
            this.mapping.register(typeToMap, typeMappedTo);
        }
    }

    private Connection estabilishConnection() throws SystemException {
        try {
            Class.forName(this.getDriver()).newInstance();
            Connection connection = DriverManager.getConnection(this.getUrl(), this.getUser(), this.getPassword());
            return connection;
        }
        catch (InstantiationException e) {
            throw new SystemException();
        }
        catch (IllegalAccessException e) {
            throw new SystemException();
        }
        catch (ClassNotFoundException e) {
            throw new SystemException("cannot create instance of driver '" + this.getDriver() + "'");
        }
        catch (SQLException e) {
            throw new SystemException("cannot get a connection to '" + this.getUrl() + "'");
        }
    }

    public void init(RuntimeServices runtimeServices) throws Exception {
    }

    public void logVelocityMessage(int i, String s) {
        if (i >= this._logLevel) {
            this.log(s, i);
        }
    }

    public String getTableRegExp() {
        if (this.tableRegExp == null) {
            this.dafaultTableRegexp();
        }
        return this.tableRegExp;
    }

    public void setTableRegExp(String tableRegExp) {
        this.tableRegExp = tableRegExp;
    }
}

