/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jaxor.PrimaryKeySet;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.api.InstanceCache;

public class InstanceCacheImpl
implements InstanceCache {
    private final Map _cache = new HashMap(5000);

    public void remove(EntityInterface abstractEntity) {
        this._cache.remove(new CacheKey(abstractEntity));
    }

    public EntityInterface updateCache(EntityInterface result) {
        CacheKey key = new CacheKey(result);
        EntityInterface priorCache = this._cache.put(key, result);
        if (priorCache == null) {
            return result;
        }
        this._cache.put(key, priorCache);
        return priorCache;
    }

    public EntityInterface getFromCache(Class _implClass, PrimaryKeySet pk) {
        return (EntityInterface)this._cache.get(new CacheKey(_implClass, pk));
    }

    public void clear() {
        this._cache.clear();
    }

    private static class CacheKey
    implements Serializable {
        private final Class _implClass;
        private final PrimaryKeySet _pk;

        public CacheKey(Class implClass, PrimaryKeySet pk) {
            this._implClass = implClass;
            this._pk = pk;
        }

        public CacheKey(EntityInterface entity) {
            this._implClass = entity.getImplementationClass();
            this._pk = entity.getPrimaryKeySet();
        }

        public int hashCode() {
            return this._pk.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass().equals(this.getClass())) {
                return this.equals((CacheKey)obj);
            }
            return false;
        }

        public boolean equals(CacheKey key) {
            return key._implClass.equals(this._implClass) && key._pk.equals(this._pk);
        }
    }
}

