/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.jaxor.api.MapperRegistry;
import net.sourceforge.jaxor.impl.MapperRegistryImpl;
import net.sourceforge.jaxor.parser.Attribute;
import net.sourceforge.jaxor.parser.Entity;
import net.sourceforge.jaxor.parser.EntityCollection;
import net.sourceforge.jaxor.parser.Generator;
import net.sourceforge.jaxor.parser.Import;
import net.sourceforge.jaxor.parser.ImportSet;
import net.sourceforge.jaxor.parser.SourceClass;
import net.sourceforge.jaxor.parser.SourceGenerator;
import net.sourceforge.jaxor.parser.SourceMap;
import net.sourceforge.jaxor.util.SystemException;
import org.apache.velocity.runtime.log.LogSystem;

public class Jaxor {
    private Entity _entity;
    private ImportSet _imports = new ImportSet();
    private String _package;
    private Generator _config;
    private File _destDir;
    private Properties _mapperProps;
    private SourceMap _javaDocBuilder;
    private String _source;
    private MapperRegistry _mapperRegistry = new MapperRegistryImpl();

    public void addImport(Import imp) {
        this._imports.add(imp);
    }

    public Set getImports() {
        ImportSet set = this.getImportsSet();
        return set.getSet();
    }

    private ImportSet getImportsSet() {
        ImportSet set = new ImportSet();
        set.add(this._imports);
        return set;
    }

    public ImportSet getImportsWithPackage() {
        ImportSet set = this.getImportsSet();
        set.add(this._package + ".*");
        return set;
    }

    public void setPackage(String aPackage) {
        this._package = aPackage;
    }

    public void addEntity(Entity entity) {
        if (this._entity != null) {
            throw new SystemException("Only one entity allowed per jaxor file");
        }
        this._entity = entity;
    }

    public String getPackageNameAsDir() {
        return this._package.replace('.', File.separatorChar);
    }

    public String getPackageName() {
        return this._package;
    }

    public void setConfig(Generator config) {
        this._config = config;
    }

    public void setDestDir(File dir) {
        this._destDir = dir;
    }

    public void execute(EntityCollection coll, LogSystem logger) {
        Entity entity = this.getEntity();
        Iterator it = this._config.getAttributes().iterator();
        while (it.hasNext()) {
            entity.addAttribute((Attribute)it.next());
        }
        File destdir = new File(this._destDir.getPath() + File.separator + this.getPackageNameAsDir());
        long timestamp = this.getLastModified();
        SourceGenerator gen = new SourceGenerator(this, destdir, timestamp, logger);
        gen.addToContext("entityCollection", coll);
        gen.add("Finder.vm", this.getEntity().getFinderName());
        gen.add("Impl.vm", this.getEntity().getImplName());
        gen.add("Interface.vm", this.getEntity().getInterfaceName());
        gen.add("List.vm", this.getEntity().getGeneratedListName());
        gen.add("Iterator.vm", this.getEntity().getIteratorName());
        gen.add("FinderImpl.vm", this.getEntity().getFinderImpl());
        gen.add("Meta.vm", this.getEntity().getMetaName());
        gen.add("EntityRow.vm", this.getEntity().getEntityRowName());
        gen.add("ResultSet.vm", this.getEntity().getEntityResultSetClass());
        gen.add("QueryResult.vm", this.getEntity().getEntityQueryResultClass());
        gen.generate();
    }

    private long getLastModified() {
        String impl = this.getEntity().getImpl();
        long metaModified = new File(this._source).lastModified();
        if (impl == null) {
            return metaModified;
        }
        long timestamp = this._javaDocBuilder.getTimestamp(impl);
        return timestamp > metaModified ? timestamp : metaModified;
    }

    public SourceClass getImplClass() {
        String impl = this.getEntity().getImpl();
        if (impl == null) {
            return null;
        }
        JavaClass daClass = this._javaDocBuilder.get(impl);
        if (daClass != null) {
            return new SourceClass(daClass);
        }
        throw new SystemException("Unable to find 'impl' class for " + this.getEntity().getTableName() + " class " + impl);
    }

    public List getImplMethods() {
        SourceClass daClass = this.getImplClass();
        if (daClass == null) {
            return Collections.EMPTY_LIST;
        }
        return daClass.getImplMethods();
    }

    public void setMapperProps(Properties mapperProps) {
        this._mapperProps = mapperProps;
    }

    public Entity getEntity() {
        return this._entity;
    }

    public List getFields(EntityCollection coll) {
        return this.getEntity().getFields(coll, this);
    }

    public List getForeignFields(EntityCollection coll) {
        return this.getEntity().getForeignFields(coll, this);
    }

    public String getMapperName(String type) {
        String map = (String)((Hashtable)this._mapperProps).get(type);
        if (map == null) {
            map = this._mapperRegistry.getName(type);
        }
        if (map == null) {
            throw new SystemException("Mapper not specified and mapper not found in registry for: " + type);
        }
        return map;
    }

    public String getExtends() {
        return this._config.getExtends(this._entity);
    }

    public String getImplements() {
        return this._config.getImplements(this._entity);
    }

    public List getQueries() {
        return this.getEntity().getQueries(this);
    }

    public void setJavaDocBuilders(SourceMap javaDocBuilders) {
        this._javaDocBuilder = javaDocBuilders;
    }

    public void setSource(String src) {
        this._source = src;
    }

    public String getFullName() {
        return this.getPackageName() + "." + this.getEntity().getTableName();
    }

    public Attribute findAttribute(String key) {
        return this.getEntity().findAttribute(key);
    }

    public String getListClassFull() {
        return this.getPackageName() + "." + this.getEntity().getListClass();
    }

    public String getEntityClassFull() {
        return this.getPackageName() + "." + this.getEntity().getInterfaceName();
    }

    public String getFinderImplFull() {
        return this.getPackageName() + "." + this.getEntity().getFinderImpl();
    }
}

