/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.util.ArrayList;
import java.util.List;

public class SourceClass {
    private final JavaClass _class;

    public SourceClass(JavaClass aClass) {
        this._class = aClass;
    }

    public List getImplMethods() {
        ArrayList<String> _methods = new ArrayList<String>();
        JavaMethod[] methods = this._class.getMethods();
        int i = 0;
        while (i < methods.length) {
            JavaMethod method = methods[i];
            if (method.isPublic() && !method.isConstructor() && !method.isStatic()) {
                String value = "public ";
                value = value + this.getType(method.getReturns()) + " ";
                value = value + method.getName() + "(";
                JavaParameter[] params = method.getParameters();
                int j = 0;
                while (j < params.length) {
                    JavaParameter param = params[j];
                    if (j > 0) {
                        value = value + ",";
                    }
                    value = value + this.getType(param.getType()) + " " + param.getName();
                    ++j;
                }
                value = value + ")";
                value = value + this.getExceptions(method.getExceptions());
                value = value + ";";
                _methods.add(value);
            }
            ++i;
        }
        return _methods;
    }

    private String getType(Type t) {
        if (!t.isArray()) {
            return t.getValue();
        }
        return t.getValue() + "[]";
    }

    private String getExceptions(Type[] types) {
        String exc = "";
        if (types.length == 0) {
            return exc;
        }
        exc = exc + "throws ";
        int i = 0;
        while (i < types.length) {
            Type type = types[i];
            if (i > 0) {
                exc = exc + ", ";
            }
            exc = exc + this.getType(type);
            ++i;
        }
        return exc;
    }
}

