/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.parser.CodeTemplate;
import net.sourceforge.jaxor.parser.Jaxor;
import net.sourceforge.jaxor.util.SystemException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.runtime.log.LogSystem;

public class SourceGenerator {
    private final File _destdir;
    private final long _timestamp;
    private final List _configs = new ArrayList();
    private final VelocityContext _context = new VelocityContext();
    private final CodeTemplate _code;

    public SourceGenerator(Jaxor jaxor, File destdir, long timestamp, LogSystem log) {
        this._destdir = destdir;
        this._timestamp = timestamp;
        this._context.put("jaxor", jaxor);
        this._code = new CodeTemplate(log, this._context);
    }

    public void addToContext(String name, Object obj) {
        this._context.put(name, obj);
    }

    public void add(String template, String fileName) {
        this._configs.add(new Config(template, fileName));
    }

    public void generate() {
        Iterator iter = this._configs.iterator();
        while (iter.hasNext()) {
            Config element = (Config)iter.next();
            this.generate(element);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generate(Config config) {
        boolean bl;
        PrintStream out = null;
        try {
            try {
                File file = new File(this._destdir, config.file + ".java");
                if (file.exists() && file.lastModified() > this._timestamp) {
                    boolean bl2 = false;
                    Object var6_7 = null;
                    if (out == null) return bl2;
                    out.flush();
                    out.close();
                    return bl2;
                }
                System.out.println("Generating " + file.getPath());
                this._destdir.mkdirs();
                out = new PrintStream(new FileOutputStream(file));
                this.print(out, config.template);
                bl = true;
            }
            catch (IOException exc) {
                throw new SystemException(exc);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (out == null) throw throwable;
            out.flush();
            out.close();
            throw throwable;
        }
        Object var6_8 = null;
        if (out == null) return bl;
        out.flush();
        out.close();
        return bl;
    }

    public void print(PrintStream out, String template) {
        this._code.write(template, out);
    }

    private static class Config {
        public final String template;
        public final String file;

        public Config(String template, String file) {
            this.template = template;
            this.file = file;
        }
    }
}

