/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.util;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.sourceforge.jaxor.util.NullProxy;

public class DynamicDecorator
implements InvocationHandler,
Serializable {
    private final Object _delegate;
    private final Override[] _list;

    public static Object create(Object delegate, Override override) {
        return DynamicDecorator.create(delegate, new Override[]{override});
    }

    public static Object create(Object delegate, Override[] list) {
        return DynamicDecorator.create(delegate.getClass().getClassLoader(), delegate, (Class[])delegate.getClass().getInterfaces(), list);
    }

    public static Object create(ClassLoader loader, Object delegate, Class[] interfaces, Override list) {
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new DynamicDecorator(delegate, new Override[]{list}));
    }

    public static Object create(ClassLoader loader, Object delegate, Class[] interfaces, Override[] list) {
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new DynamicDecorator(delegate, list));
    }

    private DynamicDecorator(Object delegate, Override[] list) {
        this._delegate = delegate;
        this._list = list;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Override over = this.findOverride(method);
            if (over != null) {
                return over.invokeSuper(this._delegate, args, method);
            }
            return method.invoke(this._delegate, args);
        }
        catch (InvocationTargetException targetExc) {
            throw targetExc.getTargetException();
        }
    }

    private Override findOverride(Method method) {
        int i = 0;
        while (i < this._list.length) {
            Override override = this._list[i];
            if (override.equalsMethod(method)) {
                return override;
            }
            ++i;
        }
        return null;
    }

    public static class Override {
        private String _method;
        private Class[] _args;

        public Override(String methodName, Class[] args) {
            this._method = methodName;
            this._args = args;
        }

        public Object invokeSuper(Object delegate, Object[] args, Method method) throws Throwable {
            try {
                return this.invoke(delegate, args, method);
            }
            catch (InvocationTargetException targetExc) {
                throw targetExc.getTargetException();
            }
        }

        protected Object invoke(Object delegate, Object[] args, Method method) throws Throwable {
            return NullProxy.getDefaultInstance(method.getReturnType());
        }

        public boolean equalsMethod(Method method) {
            if (this._method.equals(method.getName())) {
                Class<?>[] mArgs = method.getParameterTypes();
                if (mArgs.length != this._args.length) {
                    return false;
                }
                int j = 0;
                while (j < mArgs.length) {
                    if (!mArgs[j].equals(this._args[j])) {
                        return false;
                    }
                    ++j;
                }
                return true;
            }
            return false;
        }
    }
}

