/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.EntityRow;
import net.sourceforge.jaxor.LazyLoader;
import net.sourceforge.jaxor.MetaField;
import net.sourceforge.jaxor.ReferenceResolver;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.api.EntityListAdapter;

public class ForeignFieldLazyLoader
extends LazyLoader {
    private final ReferenceResolver _resolver;

    public ForeignFieldLazyLoader(Class finderClass, EntityRow parent, boolean unique) {
        this(new ReferenceResolver(finderClass, parent, unique));
    }

    public ForeignFieldLazyLoader(ReferenceResolver keys) {
        this._resolver = keys;
    }

    public void addKey(MetaField sourceField, MetaField targetField) {
        this.getResolver().add(sourceField, targetField);
    }

    public ReferenceResolver getResolver() {
        return this._resolver;
    }

    protected Object resolve() {
        return this._resolver.getObject();
    }

    public void setValue(Object result) {
        super.setValue(result);
        if (result == null) {
            return;
        }
        if (this.getResolver().isUnique()) {
            this.syncSourceFieldsWithTarget(result);
        }
    }

    public List getFieldAsList() {
        if (this.getResolver().isUnique()) {
            ArrayList<Object> result = new ArrayList<Object>();
            Object value = this.getValue();
            if (value != null) {
                result.add(value);
            }
            return result;
        }
        return ((EntityListAdapter)this.getValue()).toList();
    }

    private void syncSourceFieldsWithTarget(Object result) {
        List keys = this.getResolver().getKeys();
        EntityRow targetEntity = ((EntityInterface)result).getFields();
        EntityRow sourceEntity = this.getResolver().getSourceEntity();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            ReferenceResolver.MetaPair metaPair = (ReferenceResolver.MetaPair)iterator.next();
            String sourceProperty = metaPair.Source.getProperty();
            String targetProperty = metaPair.Target.getProperty();
            sourceEntity.setPropertyValue(sourceProperty, targetEntity.getPropertyValue(targetProperty));
        }
    }
}

