/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.provider.UriParser;

public abstract class AbstractFileName
implements FileName {
    private final String scheme;
    private final String absPath;
    private String uri;
    private String baseName;
    private String rootUri;
    private String extension;

    public AbstractFileName(String scheme, String absPath) {
        this.scheme = scheme;
        this.absPath = absPath != null && absPath.length() > 0 ? absPath : "/";
    }

    public int hashCode() {
        return this.getRootURI().hashCode() ^ this.absPath.hashCode();
    }

    public boolean equals(Object obj) {
        AbstractFileName name = (AbstractFileName)obj;
        return this.getRootURI().equals(name.getRootURI()) && this.absPath.equals(name.absPath);
    }

    public int compareTo(Object obj) {
        AbstractFileName name = (AbstractFileName)obj;
        int ret = this.getRootURI().compareTo(name.getRootURI());
        if (ret != 0) {
            return ret;
        }
        return this.absPath.compareTo(name.absPath);
    }

    public String toString() {
        return this.getURI();
    }

    protected abstract FileName createName(String var1);

    protected abstract void appendRootUri(StringBuffer var1);

    public String getBaseName() {
        if (this.baseName == null) {
            int idx = this.absPath.lastIndexOf(47);
            this.baseName = idx == -1 ? this.absPath : this.absPath.substring(idx + 1);
        }
        return this.baseName;
    }

    public String getPath() {
        return this.absPath;
    }

    public FileName resolveName(String name, NameScope scope) throws FileSystemException {
        StringBuffer buffer = new StringBuffer(name);
        UriParser.fixSeparators(buffer);
        if (name.length() == 0 || name.charAt(0) != '/') {
            buffer.insert(0, '/');
            buffer.insert(0, this.absPath);
        }
        UriParser.normalisePath(buffer);
        String resolvedPath = buffer.toString();
        if (!this.checkName(this.absPath, resolvedPath, scope)) {
            throw new FileSystemException("vfs.provider/invalid-descendent-name.error", name);
        }
        return this.createName(resolvedPath);
    }

    public FileName getParent() {
        int idx = this.absPath.lastIndexOf(47);
        if (idx == -1 || idx == this.absPath.length() - 1) {
            return null;
        }
        String parentPath = idx == 0 ? "/" : this.absPath.substring(0, idx);
        return this.createName(parentPath);
    }

    public FileName resolveName(String path) throws FileSystemException {
        return this.resolveName(path, NameScope.FILE_SYSTEM);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getURI() {
        if (this.uri == null) {
            StringBuffer buffer = new StringBuffer();
            this.appendRootUri(buffer);
            buffer.append(this.absPath);
            this.uri = buffer.toString();
        }
        return this.uri;
    }

    public String getRelativeName(FileName name) throws FileSystemException {
        int pos;
        String path = name.getPath();
        int basePathLen = this.absPath.length();
        int pathLen = path.length();
        if (basePathLen == 1 && pathLen == 1) {
            return ".";
        }
        if (basePathLen == 1) {
            return path.substring(1);
        }
        int maxlen = Math.min(basePathLen, pathLen);
        for (pos = 0; pos < maxlen && this.absPath.charAt(pos) == path.charAt(pos); ++pos) {
        }
        if (pos == basePathLen && pos == pathLen) {
            return ".";
        }
        if (pos == basePathLen && pos < pathLen && path.charAt(pos) == '/') {
            return path.substring(pos + 1);
        }
        StringBuffer buffer = new StringBuffer();
        if (pathLen > 1 && (pos < pathLen || this.absPath.charAt(pos) != '/')) {
            pos = this.absPath.lastIndexOf(47, pos);
            buffer.append(path.substring(pos));
        }
        buffer.insert(0, "..");
        pos = this.absPath.indexOf(47, pos + 1);
        while (pos != -1) {
            buffer.insert(0, "../");
            pos = this.absPath.indexOf(47, pos + 1);
        }
        return buffer.toString();
    }

    public String getRootURI() {
        if (this.rootUri == null) {
            StringBuffer buffer = new StringBuffer();
            this.appendRootUri(buffer);
            buffer.append('/');
            this.rootUri = buffer.toString();
        }
        return this.rootUri;
    }

    public int getDepth() {
        int len = this.absPath.length();
        if (len == 0 || len == 1 && this.absPath.charAt(0) == '/') {
            return 0;
        }
        int depth = 1;
        int pos = 0;
        while (pos > -1 && pos < len) {
            pos = this.absPath.indexOf(47, pos + 1);
            ++depth;
        }
        return depth;
    }

    public String getExtension() {
        if (this.extension == null) {
            this.getBaseName();
            int pos = this.baseName.lastIndexOf(46);
            this.extension = pos < 1 || pos == this.baseName.length() - 1 ? "" : this.baseName.substring(pos + 1);
        }
        return this.extension;
    }

    public boolean isAncestor(FileName ancestor) {
        if (!ancestor.getRootURI().equals(this.getRootURI())) {
            return false;
        }
        return this.checkName(ancestor.getPath(), this.absPath, NameScope.DESCENDENT);
    }

    public boolean isDescendent(FileName descendent) {
        return this.isDescendent(descendent, NameScope.DESCENDENT);
    }

    public boolean isDescendent(FileName descendent, NameScope scope) {
        if (!descendent.getRootURI().equals(this.getRootURI())) {
            return false;
        }
        return this.checkName(this.absPath, descendent.getPath(), scope);
    }

    private boolean checkName(String basePath, String path, NameScope scope) {
        if (scope == NameScope.FILE_SYSTEM) {
            return true;
        }
        if (!path.startsWith(basePath)) {
            return false;
        }
        int baseLen = basePath.length();
        if (scope == NameScope.CHILD) {
            if (path.length() == baseLen || baseLen > 1 && path.charAt(baseLen) != '/' || path.indexOf(47, baseLen + 1) != -1) {
                return false;
            }
        } else if (scope == NameScope.DESCENDENT) {
            if (path.length() == baseLen || baseLen > 1 && path.charAt(baseLen) != '/') {
                return false;
            }
        } else if (scope == NameScope.DESCENDENT_OR_SELF) {
            if (baseLen > 1 && path.length() > baseLen && path.charAt(baseLen) != '/') {
                return false;
            }
        } else if (scope != NameScope.FILE_SYSTEM) {
            throw new IllegalArgumentException();
        }
        return true;
    }
}

