/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.apache.commons.vfs.provider.UriParser;

public class GenericFileName
extends AbstractFileName {
    private final String userName;
    private final String hostName;
    private final int defaultPort;
    private final String password;
    private final int port;
    private static final char[] USERNAME_RESERVED = new char[]{':', '@'};
    private static final char[] PASSWORD_RESERVED = new char[]{'@'};

    protected GenericFileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path) {
        super(scheme, path);
        this.hostName = hostName;
        this.defaultPort = defaultPort;
        this.password = password;
        this.userName = userName;
        this.port = port > 0 ? port : this.getDefaultPort();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    protected FileName createName(String absPath) {
        return new GenericFileName(this.getScheme(), this.hostName, this.port, this.defaultPort, this.userName, this.password, absPath);
    }

    public static GenericFileName parseUri(String uri, int defaultPort) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        Authority auth = GenericFileName.extractToPath(uri, name);
        UriParser.decode(name, 0, name.length());
        UriParser.normalisePath(name);
        String path = name.toString();
        return new GenericFileName(auth.scheme, auth.hostName, auth.port, defaultPort, auth.userName, auth.password, path);
    }

    protected static Authority extractToPath(String uri, StringBuffer name) throws FileSystemException {
        String password;
        String userName;
        Authority auth = new Authority();
        auth.scheme = UriParser.extractScheme(uri, name);
        if (name.length() < 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", uri);
        }
        name.delete(0, 2);
        String userInfo = GenericFileName.extractUserInfo(name);
        if (userInfo != null) {
            int idx = userInfo.indexOf(58);
            if (idx == -1) {
                userName = userInfo;
                password = null;
            } else {
                userName = userInfo.substring(0, idx);
                password = userInfo.substring(idx + 1);
            }
        } else {
            userName = null;
            password = null;
        }
        auth.userName = UriParser.decode(userName);
        auth.password = UriParser.decode(password);
        String hostName = GenericFileName.extractHostName(name);
        if (hostName == null) {
            throw new FileSystemException("vfs.provider/missing-hostname.error", uri);
        }
        auth.hostName = hostName.toLowerCase();
        auth.port = GenericFileName.extractPort(name, uri);
        if (name.length() > 0 && name.charAt(0) != '/') {
            throw new FileSystemException("vfs.provider/missing-hostname-path-sep.error", uri);
        }
        return auth;
    }

    protected static String extractUserInfo(StringBuffer name) {
        int maxlen = name.length();
        for (int pos = 0; pos < maxlen; ++pos) {
            char ch = name.charAt(pos);
            if (ch == '@') {
                String userInfo = name.substring(0, pos);
                name.delete(0, pos + 1);
                return userInfo;
            }
            if (ch == '/' || ch == '?') break;
        }
        return null;
    }

    protected static String extractHostName(StringBuffer name) {
        char ch;
        int pos;
        int maxlen = name.length();
        for (pos = 0; pos < maxlen && (ch = name.charAt(pos)) != '/' && ch != ';' && ch != '?' && ch != ':' && ch != '@' && ch != '&' && ch != '=' && ch != '+' && ch != '$' && ch != ','; ++pos) {
        }
        if (pos == 0) {
            return null;
        }
        String hostname = name.substring(0, pos);
        name.delete(0, pos);
        return hostname;
    }

    private static int extractPort(StringBuffer name, String uri) throws FileSystemException {
        char ch;
        int pos;
        if (name.length() < 1 || name.charAt(0) != ':') {
            return -1;
        }
        int maxlen = name.length();
        for (pos = 1; pos < maxlen && (ch = name.charAt(pos)) >= '0' && ch <= '9'; ++pos) {
        }
        String port = name.substring(1, pos);
        name.delete(0, pos);
        if (port.length() == 0) {
            throw new FileSystemException("vfs.provider/missing-port.error", uri);
        }
        return Integer.parseInt(port);
    }

    protected void appendRootUri(StringBuffer buffer) {
        buffer.append(this.getScheme());
        buffer.append("://");
        if (this.userName != null && this.userName.length() != 0) {
            UriParser.appendEncoded(buffer, this.userName, USERNAME_RESERVED);
            if (this.password != null && this.password.length() != 0) {
                buffer.append(':');
                UriParser.appendEncoded(buffer, this.password, PASSWORD_RESERVED);
            }
            buffer.append('@');
        }
        buffer.append(this.hostName);
        if (this.port != this.getDefaultPort()) {
            buffer.append(':');
            buffer.append(this.port);
        }
    }

    protected static class Authority {
        public String scheme;
        public String hostName;
        public String userName;
        public String password;
        public int port;

        protected Authority() {
        }
    }
}

