/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.jar;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.jar.JarFileSystem;
import org.apache.commons.vfs.provider.zip.ZipFileObject;

public class JarFileObject
extends ZipFileObject {
    private Attributes attributes;
    final JarFileSystem fs;

    protected JarFileObject(FileName name, ZipEntry entry, JarFileSystem fs, boolean zipExists) throws FileSystemException {
        super(name, entry, fs, zipExists);
        this.fs = fs;
    }

    Manifest getManifest() throws IOException {
        if (this.fs.getZipFile() == null) {
            return null;
        }
        return ((JarFile)this.fs.getZipFile()).getManifest();
    }

    Attributes getAttributes() throws IOException {
        if (this.attributes == null) {
            if (this.entry == null) {
                this.attributes = new Attributes(1);
            } else {
                this.attributes = ((JarEntry)this.entry).getAttributes();
                if (this.attributes == null) {
                    this.attributes = new Attributes(1);
                }
            }
        }
        return this.attributes;
    }

    protected Map doGetAttributes() throws Exception {
        HashMap attrs = new HashMap();
        JarFileSystem fs = (JarFileSystem)this.getFileSystem();
        this.addAll(fs.getAttributes(), attrs);
        this.addAll(this.getAttributes(), attrs);
        return attrs;
    }

    private void addAll(Attributes src, Map dest) {
        Iterator<Map.Entry<Object, Object>> iterator = src.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String name = entry.getKey().toString().toLowerCase();
            dest.put(name, entry.getValue());
        }
    }

    protected Certificate[] doGetCertificates() {
        if (this.entry == null) {
            return null;
        }
        return ((JarEntry)this.entry).getCertificates();
    }
}

