/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.UriParser;

public class TarFileName
extends LayeredFileName {
    private static final char[] TAR_URL_RESERVED_CHARS = new char[]{'!'};

    public TarFileName(String scheme, String tarFileUri, String path) {
        super(scheme, tarFileUri, path);
    }

    protected void appendRootUri(StringBuffer buffer) {
        buffer.append(this.getScheme());
        buffer.append(":");
        UriParser.appendEncoded(buffer, this.getOuterUri(), TAR_URL_RESERVED_CHARS);
        buffer.append("!");
    }

    protected FileName createName(String path) {
        return new TarFileName(this.getScheme(), this.getOuterUri(), path);
    }

    public static TarFileName parseUri(String uri) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        String scheme = UriParser.extractScheme(uri, name);
        String tarUri = TarFileName.extractTarName(name);
        UriParser.decode(name, 0, name.length());
        UriParser.normalisePath(name);
        String path = name.toString();
        return new TarFileName(scheme, tarUri, path);
    }

    private static String extractTarName(StringBuffer uri) throws FileSystemException {
        int pos;
        int maxlen = uri.length();
        for (pos = 0; pos < maxlen && uri.charAt(pos) != '!'; ++pos) {
        }
        String prefix = uri.substring(0, pos);
        if (pos < maxlen) {
            uri.delete(0, pos + 1);
        } else {
            uri.setLength(0);
        }
        return UriParser.decode(prefix);
    }
}

