/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.tar.TarFileSystem;

public class TarFileObject
extends AbstractFileObject
implements FileObject {
    private final HashSet children = new HashSet();
    private final TarFileSystem fs;
    protected TarEntry entry;
    private FileType type;

    protected TarFileObject(FileName name, TarEntry entry, TarFileSystem fs, boolean tarExists) throws FileSystemException {
        super(name, fs);
        this.fs = fs;
        this.setTarEntry(entry);
        if (!tarExists) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setTarEntry(TarEntry entry) {
        if (this.entry != null) {
            return;
        }
        this.type = entry == null || entry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = entry;
    }

    public void attachChild(FileName childName) {
        this.children.add(childName.getBaseName());
    }

    public boolean isWriteable() {
        return false;
    }

    protected FileType doGetType() {
        return this.type;
    }

    protected String[] doListChildren() {
        return this.children.toArray(new String[this.children.size()]);
    }

    protected long doGetContentSize() {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getModTime().getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.fs.getInputStream(this.entry);
    }
}

