/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.webdav.WebdavFileObject;
import org.apache.commons.vfs.provider.webdav.WebdavFileProvider;

public class WebDavFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final HttpClient client;

    protected WebDavFileSystem(GenericFileName rootName, HttpClient client, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.client = client;
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(WebdavFileProvider.capabilities);
    }

    protected HttpClient getClient() throws FileSystemException {
        return this.client;
    }

    protected FileObject createFile(FileName name) {
        GenericFileName fileName = (GenericFileName)name;
        return new WebdavFileObject(fileName, this);
    }
}

