/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportWriteDataAbstract;

final class ExportWriteData
extends ExportWriteDataAbstract
implements PrivilegedExceptionAction {
    private String outputFileName;
    private OutputStreamWriter aStream;

    ExportWriteData(String string, ControlInfo controlInfo) throws Exception {
        this.outputFileName = string;
        this.controlFileReader = controlInfo;
        this.loadPropertiesInfo();
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    public final Object run() throws Exception {
        this.openFile();
        return null;
    }

    private void openFile() throws Exception {
        Object object;
        try {
            object = new URL(this.outputFileName);
            this.outputFileName = ((URL)object).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        object = new FileOutputStream(this.outputFileName);
        this.aStream = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)object), this.dataCodeset);
    }

    void writeColumnDefinitionOptionally(String[] stringArray, String[] stringArray2) throws Exception {
        boolean bl = true;
        if (this.columnDefinition.toUpperCase(Locale.ENGLISH).equals("True".toUpperCase(Locale.ENGLISH))) {
            String string = new String();
            for (int i = 0; i < stringArray.length; ++i) {
                string = i > 0 ? this.fieldSeparator : "";
                string = string + this.fieldStartDelimiter + stringArray[i] + this.fieldStopDelimiter;
                if (!bl) {
                    string = string + this.fieldSeparator + this.fieldStartDelimiter + stringArray2[i] + this.fieldStopDelimiter;
                }
                this.aStream.write(string, 0, string.length());
            }
            this.aStream.write(this.recordSeparator, 0, this.recordSeparator.length());
        }
    }

    private void writeNextColumn(String string, boolean bl) throws Exception {
        if (string != null) {
            if (!bl) {
                this.aStream.write(this.fieldStartDelimiter, 0, this.fieldStartDelimiter.length());
            }
            if (this.doubleDelimiter) {
                string = this.makeDoubleDelimiterString(string, this.fieldStartDelimiter);
            }
            this.aStream.write(string, 0, string.length());
            if (!bl) {
                this.aStream.write(this.fieldStopDelimiter, 0, this.fieldStopDelimiter.length());
            }
        }
    }

    public void writeData(String[] stringArray, boolean[] blArray) throws Exception {
        if (this.format.equals("ASCII_DELIMITED")) {
            this.writeNextColumn(stringArray[0], blArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                this.aStream.write(this.fieldSeparator, 0, this.fieldSeparator.length());
                this.writeNextColumn(stringArray[i], blArray[i]);
            }
            if (this.hasDelimiterAtEnd) {
                this.aStream.write(this.fieldSeparator, 0, this.fieldSeparator.length());
            }
        }
        this.aStream.write(this.recordSeparator, 0, this.recordSeparator.length());
    }

    public void noMoreRows() throws IOException {
        this.aStream.flush();
        this.aStream.close();
    }

    private String makeDoubleDelimiterString(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = string2.length();
            while (n != -1) {
                stringBuffer = stringBuffer.insert(n, string2);
                int n3 = n + n2 + 1;
                n = stringBuffer.toString().indexOf(string2, n3);
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

