/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.apache.xmlrpc.util.LimitedInputStream;

public class XmlRpcLiteHttpTransport
extends XmlRpcHttpTransport {
    private final String userAgent = super.getUserAgent() + " (Lite HTTP Transport)";

    public XmlRpcLiteHttpTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    protected void setRequestHeader(Object pConnection, String pHeader, String pValue) {
        Connection conn = (Connection)pConnection;
        Object value = conn.headers.get(pHeader);
        if (value == null) {
            conn.headers.put(pHeader, pValue);
        } else {
            ArrayList<Object> list;
            if (value instanceof String) {
                list = new ArrayList<Object>();
                list.add(value);
                conn.headers.put(pHeader, list);
            } else {
                list = (ArrayList<Object>)value;
            }
            list.add(pValue);
        }
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig, Object pConnection) {
        return false;
    }

    protected Object newConnection(XmlRpcStreamRequestConfig pConfig) throws XmlRpcClientException {
        return new Connection(((XmlRpcHttpClientConfig)pConfig).getServerURL());
    }

    protected void closeConnection(Object pConnection) throws XmlRpcClientException {
        IOException e;
        block11: {
            Connection conn;
            block10: {
                conn = (Connection)pConnection;
                e = null;
                if (conn.input != null) {
                    try {
                        conn.input.close();
                    }
                    catch (IOException ex) {
                        e = ex;
                    }
                }
                if (conn.output != null) {
                    try {
                        conn.output.close();
                    }
                    catch (IOException ex) {
                        if (e == null) break block10;
                        e = ex;
                    }
                }
            }
            if (conn.socket != null) {
                try {
                    conn.socket.close();
                }
                catch (IOException ex) {
                    if (e == null) break block11;
                    e = ex;
                }
            }
        }
        if (e != null) {
            throw new XmlRpcClientException("Failed to close connection: " + e.getMessage(), e);
        }
    }

    protected OutputStream newOutputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcClientException {
        final Connection conn = (Connection)pConnection;
        int retries = 3;
        int delayMillis = 100;
        int tries = 0;
        while (true) {
            try {
                conn.socket = new Socket(conn.hostname, conn.port);
                conn.output = new BufferedOutputStream(conn.socket.getOutputStream()){

                    public void close() throws IOException {
                        this.flush();
                        conn.socket.shutdownOutput();
                    }
                };
                this.sendRequestHeaders(conn, conn.output);
                return conn.output;
            }
            catch (ConnectException e) {
                if (tries >= 3) {
                    throw new XmlRpcClientException("Failed to connect to " + conn.host + ": " + e.getMessage(), e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {}
            }
            catch (IOException e) {
                throw new XmlRpcClientException("Failed to connect to " + conn.host + ": " + e.getMessage(), e);
            }
            ++tries;
        }
    }

    private byte[] toHTTPBytes(String pValue) throws UnsupportedEncodingException {
        return pValue.getBytes("US-ASCII");
    }

    private void sendHeader(OutputStream pOut, String pKey, String pValue) throws IOException {
        pOut.write(this.toHTTPBytes(pKey + ": " + pValue + "\r\n"));
    }

    private void sendRequestHeaders(Connection pConnection, OutputStream pOut) throws IOException {
        pOut.write(("POST " + pConnection.uri + " HTTP/1.0\r\n").getBytes("US-ASCII"));
        Iterator iter = pConnection.headers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                this.sendHeader(pOut, key, (String)value);
                continue;
            }
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                this.sendHeader(pOut, key, (String)list.get(i));
            }
        }
        pOut.write(this.toHTTPBytes("\r\n"));
    }

    protected InputStream newInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection, byte[] pContent) throws XmlRpcException {
        try {
            Connection conn = (Connection)pConnection;
            conn.socket = new Socket(conn.hostname, conn.port);
            conn.output = new BufferedOutputStream(conn.socket.getOutputStream());
            this.sendRequestHeaders(conn, conn.output);
            conn.output.write(pContent);
            conn.output.flush();
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to send request to sender: " + e.getMessage(), e);
        }
        return this.newInputStream(pConfig, pConnection);
    }

    protected InputStream newInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcException {
        Connection conn = (Connection)pConnection;
        byte[] buffer = new byte[2048];
        try {
            conn.input = new BufferedInputStream(conn.socket.getInputStream());
            String line = HttpUtil.readLine(conn.input, buffer);
            StringTokenizer tokens = new StringTokenizer(line);
            tokens.nextToken();
            String statusCode = tokens.nextToken();
            String statusMsg = tokens.nextToken("\n\r");
            if (!"200".equals(statusCode)) {
                throw new IOException("Unexpected Response from Server: " + statusMsg);
            }
            int contentLength = -1;
            while ((line = HttpUtil.readLine(conn.input, buffer)) != null && !"".equals(line)) {
                if (!(line = line.toLowerCase()).startsWith("content-length:")) continue;
                contentLength = Integer.parseInt(line.substring("content-length:".length()).trim());
            }
            InputStream result = contentLength == -1 ? conn.input : new LimitedInputStream(conn.input, contentLength);
            return result;
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to read server response: " + e.getMessage(), e);
        }
    }

    private class Connection {
        private final String hostname;
        private final String host;
        private int port;
        private final String uri;
        private Socket socket;
        private OutputStream output;
        private InputStream input;
        private final Map headers = new HashMap();

        Connection(URL pURL) {
            this.hostname = pURL.getHost();
            int p = pURL.getPort();
            this.port = p < 1 ? 80 : p;
            String u = pURL.getFile();
            this.uri = u == null || "".equals(u) ? "/" : u;
            this.host = this.port == 80 ? this.hostname : this.hostname + ":" + this.port;
            this.headers.put("Host", this.host);
        }
    }
}

