/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.xerces.util.DefaultErrorHandler;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLPullParserConfiguration;
import org.cyberneko.html.HTMLComponent;
import org.cyberneko.html.HTMLErrorReporter;
import org.cyberneko.html.HTMLScanner;
import org.cyberneko.html.HTMLTagBalancer;
import org.cyberneko.html.filters.NamespaceBinder;

public class HTMLConfiguration
extends ParserConfigurationSettings
implements XMLPullParserConfiguration {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    protected static final String SIMPLE_ERROR_FORMAT = "http://cyberneko.org/html/features/report-errors/simple";
    protected static final String BALANCE_TAGS = "http://cyberneko.org/html/features/balance-tags";
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    protected static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    protected static final String ERROR_DOMAIN = "http://cyberneko.org/html";
    private static final Class[] DOCSOURCE = new Class[]{class$org$apache$xerces$xni$parser$XMLDocumentSource == null ? (class$org$apache$xerces$xni$parser$XMLDocumentSource = HTMLConfiguration.class$("org.apache.xerces.xni.parser.XMLDocumentSource")) : class$org$apache$xerces$xni$parser$XMLDocumentSource};
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected XMLErrorHandler fErrorHandler = new DefaultErrorHandler();
    protected XMLEntityResolver fEntityResolver;
    protected Locale fLocale = Locale.getDefault();
    protected boolean fCloseStream;
    protected Vector fHTMLComponents = new Vector(2);
    protected HTMLScanner fDocumentScanner = new HTMLScanner();
    protected HTMLTagBalancer fTagBalancer = new HTMLTagBalancer();
    protected NamespaceBinder fNamespaceBinder = new NamespaceBinder();
    protected HTMLErrorReporter fErrorReporter = new ErrorReporter();
    protected static boolean XERCES_2_0_0 = false;
    protected static boolean XERCES_2_0_1 = false;
    protected static boolean XML4J_4_0_x = false;
    static /* synthetic */ Class class$org$apache$xerces$xni$parser$XMLDocumentSource;

    public HTMLConfiguration() {
        this.addComponent(this.fDocumentScanner);
        this.addComponent(this.fTagBalancer);
        this.addComponent(this.fNamespaceBinder);
        String string = "http://xml.org/sax/features/validation";
        String[] stringArray = new String[]{AUGMENTATIONS, NAMESPACES, string, REPORT_ERRORS, SIMPLE_ERROR_FORMAT, BALANCE_TAGS};
        this.addRecognizedFeatures(stringArray);
        this.setFeature(AUGMENTATIONS, false);
        this.setFeature(NAMESPACES, true);
        this.setFeature(string, false);
        this.setFeature(REPORT_ERRORS, false);
        this.setFeature(SIMPLE_ERROR_FORMAT, false);
        this.setFeature(BALANCE_TAGS, true);
        if (XERCES_2_0_0) {
            stringArray = new String[]{"http://apache.org/xml/features/scanner/notify-builtin-refs"};
            this.addRecognizedFeatures(stringArray);
        }
        if (XERCES_2_0_0 || XERCES_2_0_1 || XML4J_4_0_x) {
            stringArray = new String[]{"http://apache.org/xml/features/validation/schema/normalized-value", "http://apache.org/xml/features/scanner/notify-char-refs"};
            this.addRecognizedFeatures(stringArray);
        }
        String[] stringArray2 = new String[]{NAMES_ELEMS, NAMES_ATTRS, FILTERS, ERROR_REPORTER};
        this.addRecognizedProperties(stringArray2);
        this.setProperty(NAMES_ELEMS, "upper");
        this.setProperty(NAMES_ATTRS, "lower");
        this.setProperty(ERROR_REPORTER, this.fErrorReporter);
        if (XERCES_2_0_0) {
            String string2 = "http://apache.org/xml/properties/internal/symbol-table";
            stringArray2 = new String[]{string2};
            this.addRecognizedProperties(stringArray2);
            Object object = ObjectFactory.createObject((String)"org.apache.xerces.util.SymbolTable", (String)"org.apache.xerces.util.SymbolTable");
            this.setProperty(string2, object);
        }
    }

    public void pushInputSource(XMLInputSource xMLInputSource) {
        this.fDocumentScanner.pushInputSource(xMLInputSource);
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        super.setFeature(string, bl);
        int n = this.fHTMLComponents.size();
        int n2 = 0;
        while (n2 < n) {
            HTMLComponent hTMLComponent = (HTMLComponent)this.fHTMLComponents.elementAt(n2);
            hTMLComponent.setFeature(string, bl);
            ++n2;
        }
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        Object object2;
        int n;
        XMLDocumentFilter[] xMLDocumentFilterArray;
        super.setProperty(string, object);
        if (string.equals(FILTERS) && (xMLDocumentFilterArray = (XMLDocumentFilter[])this.getProperty(FILTERS)) != null) {
            n = 0;
            while (n < xMLDocumentFilterArray.length) {
                object2 = xMLDocumentFilterArray[n];
                if (object2 instanceof HTMLComponent) {
                    this.addComponent((HTMLComponent)object2);
                }
                ++n;
            }
        }
        int n2 = this.fHTMLComponents.size();
        n = 0;
        while (n < n2) {
            object2 = (HTMLComponent)this.fHTMLComponents.elementAt(n);
            object2.setProperty(string, object);
            ++n;
        }
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
        this.fDTDContentModelHandler = xMLDTDContentModelHandler;
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorHandler = xMLErrorHandler;
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void parse(XMLInputSource xMLInputSource) throws XNIException, IOException {
        this.setInputSource(xMLInputSource);
        this.parse(true);
    }

    public void setInputSource(XMLInputSource xMLInputSource) throws XMLConfigurationException, IOException {
        this.reset();
        this.fCloseStream = xMLInputSource.getByteStream() == null && xMLInputSource.getCharacterStream() == null;
        this.fDocumentScanner.setInputSource(xMLInputSource);
    }

    public boolean parse(boolean bl) throws XNIException, IOException {
        try {
            boolean bl2 = this.fDocumentScanner.scanDocument(bl);
            if (!bl2) {
                this.cleanup();
            }
            return bl2;
        }
        catch (XNIException xNIException) {
            this.cleanup();
            throw xNIException;
        }
        catch (IOException iOException) {
            this.cleanup();
            throw iOException;
        }
    }

    public void cleanup() {
        this.fDocumentScanner.cleanup(this.fCloseStream);
    }

    protected void addComponent(HTMLComponent hTMLComponent) {
        Object object;
        this.fHTMLComponents.addElement(hTMLComponent);
        String[] stringArray = hTMLComponent.getRecognizedFeatures();
        this.addRecognizedFeatures(stringArray);
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            object = hTMLComponent.getFeatureDefault(stringArray[n2]);
            if (object != null) {
                this.setFeature(stringArray[n2], (Boolean)object);
            }
            ++n2;
        }
        object = hTMLComponent.getRecognizedProperties();
        this.addRecognizedProperties((String[])object);
        int n3 = object != null ? ((String[])object).length : 0;
        int n4 = 0;
        while (n4 < n3) {
            Object object2 = hTMLComponent.getPropertyDefault((String)object[n4]);
            if (object2 != null) {
                this.setProperty((String)object[n4], object2);
            }
            ++n4;
        }
    }

    protected void reset() throws XMLConfigurationException {
        XMLDocumentFilter[] xMLDocumentFilterArray;
        Object object;
        int n = this.fHTMLComponents.size();
        int n2 = 0;
        while (n2 < n) {
            object = (HTMLComponent)this.fHTMLComponents.elementAt(n2);
            object.reset(this);
            ++n2;
        }
        object = this.fDocumentScanner;
        if (this.getFeature(BALANCE_TAGS)) {
            object.setDocumentHandler(this.fTagBalancer);
            this.fTagBalancer.setDocumentSource(this.fDocumentScanner);
            object = this.fTagBalancer;
        }
        if (this.getFeature(NAMESPACES)) {
            object.setDocumentHandler(this.fNamespaceBinder);
            this.fNamespaceBinder.setDocumentSource(this.fTagBalancer);
            object = this.fNamespaceBinder;
        }
        if ((xMLDocumentFilterArray = (XMLDocumentFilter[])this.getProperty(FILTERS)) != null) {
            int n3 = 0;
            while (n3 < xMLDocumentFilterArray.length) {
                XMLDocumentFilter xMLDocumentFilter = xMLDocumentFilterArray[n3];
                Class<?> clazz = xMLDocumentFilter.getClass();
                try {
                    Method method = clazz.getMethod("setDocumentSource", DOCSOURCE);
                    if (method != null) {
                        method.invoke((Object)xMLDocumentFilter, object);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                object.setDocumentHandler(xMLDocumentFilter);
                object = xMLDocumentFilter;
                ++n3;
            }
        }
        object.setDocumentHandler(this.fDocumentHandler);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = "org.apache.xerces.impl.Version";
            Object object = ObjectFactory.createObject((String)string, (String)string);
            Field field = object.getClass().getField("fVersion");
            String string2 = String.valueOf(field.get(object));
            XERCES_2_0_0 = string2.equals("Xerces-J 2.0.0");
            XERCES_2_0_1 = string2.equals("Xerces-J 2.0.1");
            XML4J_4_0_x = string2.startsWith("XML4J 4.0.");
        }
        catch (Throwable throwable) {}
    }

    protected class ErrorReporter
    implements HTMLErrorReporter {
        protected Locale fLastLocale;
        protected ResourceBundle fErrorMessages;

        protected ErrorReporter() {
        }

        public String formatMessage(String string, Object[] objectArray) {
            if (!HTMLConfiguration.this.getFeature(HTMLConfiguration.SIMPLE_ERROR_FORMAT)) {
                if (!HTMLConfiguration.this.fLocale.equals(this.fLastLocale)) {
                    this.fErrorMessages = null;
                    this.fLastLocale = HTMLConfiguration.this.fLocale;
                }
                if (this.fErrorMessages == null) {
                    this.fErrorMessages = ResourceBundle.getBundle("org/cyberneko/html/res/ErrorMessages", HTMLConfiguration.this.fLocale);
                }
                try {
                    String string2 = this.fErrorMessages.getString(string);
                    String string3 = MessageFormat.format(string2, objectArray);
                    return string3;
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            return this.formatSimpleMessage(string, objectArray);
        }

        public void reportWarning(String string, Object[] objectArray) throws XMLParseException {
            if (HTMLConfiguration.this.fErrorHandler != null) {
                HTMLConfiguration.this.fErrorHandler.warning(HTMLConfiguration.ERROR_DOMAIN, string, this.createException(string, objectArray));
            }
        }

        public void reportError(String string, Object[] objectArray) throws XMLParseException {
            if (HTMLConfiguration.this.fErrorHandler != null) {
                HTMLConfiguration.this.fErrorHandler.error(HTMLConfiguration.ERROR_DOMAIN, string, this.createException(string, objectArray));
            }
        }

        protected XMLParseException createException(String string, Object[] objectArray) {
            String string2 = this.formatMessage(string, objectArray);
            return new XMLParseException(HTMLConfiguration.this.fDocumentScanner, string2);
        }

        protected String formatSimpleMessage(String string, Object[] objectArray) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(HTMLConfiguration.ERROR_DOMAIN);
            stringBuffer.append('#');
            stringBuffer.append(string);
            if (objectArray != null && objectArray.length > 0) {
                stringBuffer.append('\t');
                int n = 0;
                while (n < objectArray.length) {
                    if (n > 0) {
                        stringBuffer.append('\t');
                    }
                    stringBuffer.append(String.valueOf(objectArray[n]));
                    ++n;
                }
            }
            return stringBuffer.toString();
        }
    }
}

