/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html.filters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.cyberneko.html.HTMLEventInfo;
import org.cyberneko.html.filters.DefaultFilter;

public class Purifier
extends DefaultFilter {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://cyberneko.org/html/features/augmentations"};
    private static final Boolean[] RECOGNIZED_FEATURES_DEFAULTS = new Boolean[]{null, null};
    protected static final HTMLEventInfo SYNTHESIZED_ITEM = new HTMLEventInfo.SynthesizedItem();
    protected boolean fNamespaces;
    protected boolean fAugmentations;
    protected boolean fSeenDoctype;
    protected boolean fSeenRootElement;
    protected boolean fInCDATASection;
    protected String fPublicId;
    protected String fSystemId;
    private QName fQName = new QName();
    private final Augmentations fInfosetAugs = new AugmentationsImpl();
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fInCDATASection = false;
        this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        this.fAugmentations = xMLComponentManager.getFeature(AUGMENTATIONS);
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.handleStartDocument();
        super.startDocument(xMLLocator, string, augmentations);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.handleStartDocument();
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        StringBuffer stringBuffer = new StringBuffer(this.purifyText(xMLString).toString());
        int n = stringBuffer.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = stringBuffer.charAt(n2);
            if (c == '-') {
                stringBuffer.insert(n2 + 1, ' ');
            }
            --n2;
        }
        this.fStringBuffer.length = 0;
        this.fStringBuffer.append(stringBuffer.toString());
        xMLString = this.fStringBuffer;
        super.comment(xMLString, augmentations);
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        string = this.purifyName(string, true);
        xMLString = this.purifyText(xMLString);
        super.processingInstruction(string, xMLString, augmentations);
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.fSeenDoctype = true;
        this.fPublicId = string2;
        this.fSystemId = string3;
        if (this.fPublicId != null && this.fSystemId == null) {
            this.fSystemId = "";
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes);
        super.startElement(qName, xMLAttributes, augmentations);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes);
        super.emptyElement(qName, xMLAttributes, augmentations);
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = true;
        super.startCDATA(augmentations);
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = false;
        super.endCDATA(augmentations);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        xMLString = this.purifyText(xMLString);
        if (this.fInCDATASection) {
            StringBuffer stringBuffer = new StringBuffer(xMLString.toString());
            int n = stringBuffer.length();
            int n2 = n - 1;
            while (n2 >= 0) {
                char c = stringBuffer.charAt(n2);
                if (c == ']') {
                    stringBuffer.insert(n2 + 1, ' ');
                }
                --n2;
            }
            this.fStringBuffer.length = 0;
            this.fStringBuffer.append(stringBuffer.toString());
            xMLString = this.fStringBuffer;
        }
        super.characters(xMLString, augmentations);
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        qName = this.purifyQName(qName);
        super.endElement(qName, augmentations);
    }

    protected void handleStartDocument() {
        this.fSeenDoctype = false;
        this.fSeenRootElement = false;
    }

    protected void handleStartElement(QName qName, XMLAttributes xMLAttributes) {
        qName = this.purifyQName(qName);
        int n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            xMLAttributes.getName(n2, this.fQName);
            xMLAttributes.setName(n2, this.purifyQName(this.fQName));
            ++n2;
        }
        if (!this.fSeenRootElement && this.fSeenDoctype) {
            Augmentations augmentations = this.synthesizedAugs();
            super.doctypeDecl(qName.rawname, this.fPublicId, this.fSystemId, augmentations);
        }
        this.fSeenRootElement = true;
    }

    protected final Augmentations synthesizedAugs() {
        Augmentations augmentations = null;
        if (this.fAugmentations) {
            augmentations = this.fInfosetAugs;
            Class<?> clazz = augmentations.getClass();
            Method method = null;
            try {
                method = clazz.getMethod("clear", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getMethod("removeAllItems", null);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    augmentations = new AugmentationsImpl();
                }
            }
            if (method != null) {
                try {
                    method.invoke((Object)augmentations, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    augmentations = new AugmentationsImpl();
                }
                catch (InvocationTargetException invocationTargetException) {
                    augmentations = new AugmentationsImpl();
                }
            }
            augmentations.putItem(AUGMENTATIONS, SYNTHESIZED_ITEM);
        }
        return augmentations;
    }

    protected QName purifyQName(QName qName) {
        qName.prefix = this.purifyName(qName.prefix, true);
        qName.localpart = this.purifyName(qName.localpart, true);
        qName.rawname = this.purifyName(qName.rawname, false);
        return qName;
    }

    protected String purifyName(String string, boolean bl) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl2 = bl;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (n2 == 0) {
                if (!XMLChar.isNameStart(c)) {
                    stringBuffer.append("_u" + Purifier.toHexString(c, 4) + "_");
                } else {
                    stringBuffer.append(c);
                }
            } else {
                if (this.fNamespaces && c == ':' && bl2 || !XMLChar.isName(c)) {
                    stringBuffer.append("_u" + Purifier.toHexString(c, 4) + "_");
                } else {
                    stringBuffer.append(c);
                }
                bl2 = bl2 || c == ':';
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected XMLString purifyText(XMLString xMLString) {
        this.fStringBuffer.length = 0;
        int n = 0;
        while (n < xMLString.length) {
            char c = xMLString.ch[xMLString.offset + n];
            if (XMLChar.isInvalid(c)) {
                this.fStringBuffer.append("\\u" + Purifier.toHexString(c, 4));
            } else {
                this.fStringBuffer.append(c);
            }
            ++n;
        }
        return this.fStringBuffer;
    }

    protected static String toHexString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(Integer.toHexString(n));
        int n3 = n2 - stringBuffer.length();
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.insert(0, '0');
            ++n4;
        }
        return stringBuffer.toString().toUpperCase();
    }
}

