/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;

public class XmlRpcCommonsTransport
extends XmlRpcHttpTransport {
    private String userAgent = super.getUserAgent() + " (Jakarta Commons httpclient Transport)";

    public XmlRpcCommonsTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    protected void setRequestHeader(Object pConnection, String pHeader, String pValue) {
        PostMethod method = ((CommonsConnection)pConnection).method;
        method.setRequestHeader(new Header(pHeader, pValue));
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig, Object pConnection) {
        Header h = ((CommonsConnection)pConnection).method.getResponseHeader("Content-Encoding");
        if (h == null) {
            return false;
        }
        return HttpUtil.isUsingGzipEncoding(h.getValue());
    }

    protected Object newConnection(XmlRpcStreamRequestConfig pConfig) throws XmlRpcClientException {
        return new CommonsConnection((XmlRpcHttpClientConfig)pConfig);
    }

    protected void closeConnection(Object pConnection) throws XmlRpcClientException {
        ((CommonsConnection)pConnection).method.releaseConnection();
    }

    protected OutputStream newOutputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcClientException {
        throw new IllegalStateException("Not implemented");
    }

    protected boolean isUsingByteArrayOutput(XmlRpcStreamRequestConfig pConfig) {
        return true;
    }

    protected InputStream newInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcException {
        throw new IllegalStateException("Not implemented");
    }

    protected void setContentLength(Object pConnection, int pLength) {
    }

    protected InputStream newInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection, byte[] pContents) throws XmlRpcException {
        HostConfiguration hostConfig;
        XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pConfig;
        CommonsConnection conn = (CommonsConnection)pConnection;
        PostMethod method = conn.method;
        method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(pContents, "text/xml"));
        try {
            URI hostURI = new URI(config.getServerURL().toString(), false);
            hostConfig = new HostConfiguration();
            hostConfig.setHost(hostURI);
        }
        catch (URIException e) {
            throw new XmlRpcClientException("Failed to parse URL: " + config.getServerURL().toString(), e);
        }
        try {
            conn.client.executeMethod(hostConfig, (HttpMethod)method);
            return method.getResponseBodyAsStream();
        }
        catch (HttpException e) {
            throw new XmlRpcClientException("Error in HTTP transport: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcClientException("I/O error in server communication: " + e.getMessage(), e);
        }
    }

    protected void setCredentials(XmlRpcHttpClientConfig pConfig, Object pConnection) throws XmlRpcClientException {
        String userName = pConfig.getBasicUserName();
        if (userName != null) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userName, pConfig.getBasicPassword());
            AuthScope scope = new AuthScope(null, -1, null, AuthScope.ANY_SCHEME);
            ((CommonsConnection)pConnection).client.getState().setCredentials(scope, (Credentials)creds);
        }
    }

    private class CommonsConnection {
        final HttpClient client = new HttpClient();
        final PostMethod method;

        CommonsConnection(XmlRpcHttpClientConfig pConfig) {
            this.method = new PostMethod(pConfig.getServerURL().toString());
            this.method.getParams().setVersion(HttpVersion.HTTP_1_1);
        }
    }
}

