/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;

public class PropertyHandlerMapping
implements XmlRpcHandlerMapping {
    private final Map handlerMap;
    static /* synthetic */ Class class$java$lang$Object;

    public PropertyHandlerMapping(ClassLoader pClassLoader, URL pURL) throws IOException, XmlRpcException {
        this.handlerMap = this.load(pClassLoader, pURL);
    }

    public PropertyHandlerMapping(ClassLoader pClassLoader, File pFile) throws IOException, XmlRpcException {
        this.handlerMap = this.load(pClassLoader, pFile.toURL());
    }

    public PropertyHandlerMapping(ClassLoader pClassLoader, String pResource) throws IOException, XmlRpcException {
        URL url = pClassLoader.getResource(pResource);
        if (url == null) {
            throw new IOException("Unable to locate resource " + pResource);
        }
        this.handlerMap = this.load(pClassLoader, url);
    }

    private Map load(ClassLoader pClassLoader, URL pURL) throws IOException, XmlRpcException {
        HashMap<String, 1> map = new HashMap<String, 1>();
        Properties props = new Properties();
        props.load(pURL.openStream());
        Iterator iter = ((Hashtable)props).entrySet().iterator();
        while (iter.hasNext()) {
            Object o;
            Class<?> c;
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                c = pClassLoader.loadClass(value);
            }
            catch (ClassNotFoundException e) {
                throw new XmlRpcException("Unable to load class: " + value, e);
            }
            if (c == null) {
                throw new XmlRpcException(0, "Loading class " + value + " returned null.");
            }
            try {
                o = c.newInstance();
            }
            catch (InstantiationException e) {
                throw new XmlRpcException("Failed to instantiate class " + c.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new XmlRpcException("Illegal access when instantiating class " + c.getName(), e);
            }
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String name;
                final Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getReturnType() == Void.TYPE || method.getDeclaringClass() == (class$java$lang$Object == null ? PropertyHandlerMapping.class$("java.lang.Object") : class$java$lang$Object) || map.containsKey(name = key + "." + method.getName())) continue;
                map.put(name, new XmlRpcHandler(){

                    public Object execute(XmlRpcRequest pRequest) throws XmlRpcException {
                        Object[] args = new Object[pRequest.getParameterCount()];
                        for (int j = 0; j < args.length; ++j) {
                            args[j] = pRequest.getParameter(j);
                        }
                        try {
                            return method.invoke(o, args);
                        }
                        catch (IllegalAccessException e) {
                            throw new XmlRpcException("Illegal access to method " + method.getName() + " in class " + c.getName(), e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new XmlRpcException("Illegal argument for method " + method.getName() + " in class " + c.getName(), e);
                        }
                        catch (InvocationTargetException e) {
                            Throwable t = e.getTargetException();
                            throw new XmlRpcException("Failed to invoke method " + method.getName() + " in class " + c.getName() + ": " + t.getMessage(), t);
                        }
                    }
                });
            }
        }
        return map;
    }

    public XmlRpcHandler getHandler(String handlerName) throws XmlRpcNoSuchHandlerException, XmlRpcException {
        XmlRpcHandler result = (XmlRpcHandler)this.handlerMap.get(handlerName);
        if (result == null) {
            throw new XmlRpcNoSuchHandlerException("No such handler: " + handlerName);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

