/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcRequestConfig;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.parser.XmlRpcRequestParser;
import org.apache.xmlrpc.serializer.DefaultXMLWriterFactory;
import org.apache.xmlrpc.serializer.XmlRpcWriter;
import org.apache.xmlrpc.serializer.XmlWriterFactory;
import org.apache.xmlrpc.server.XmlRpcServer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlRpcStreamServer
extends XmlRpcServer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xmlrpc$server$XmlRpcStreamServer == null ? (class$org$apache$xmlrpc$server$XmlRpcStreamServer = XmlRpcStreamServer.class$("org.apache.xmlrpc.server.XmlRpcStreamServer")) : class$org$apache$xmlrpc$server$XmlRpcStreamServer));
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();
    private XmlWriterFactory writerFactory = new DefaultXMLWriterFactory();
    static /* synthetic */ Class class$org$apache$xmlrpc$server$XmlRpcStreamServer;

    protected XmlRpcRequest getRequest(final XmlRpcStreamRequestConfig pConfig, InputStream pStream) throws XmlRpcException {
        XMLReader xr;
        final XmlRpcRequestParser parser = new XmlRpcRequestParser(pConfig, this.getTypeFactory());
        try {
            xr = spf.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new XmlRpcException("Unable to create XML parser: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new XmlRpcException("Unable to create XML parser: " + e.getMessage(), e);
        }
        xr.setContentHandler(parser);
        try {
            xr.parse(new InputSource(pStream));
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null && ex instanceof XmlRpcException) {
                throw (XmlRpcException)ex;
            }
            throw new XmlRpcException("Failed to parse XML-RPC request: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to read XML-RPC request: " + e.getMessage(), e);
        }
        final List params = parser.getParams();
        return new XmlRpcRequest(){

            public XmlRpcRequestConfig getConfig() {
                return pConfig;
            }

            public String getMethodName() {
                return parser.getMethodName();
            }

            public int getParameterCount() {
                return params.size();
            }

            public Object getParameter(int pIndex) {
                return params.get(pIndex);
            }
        };
    }

    protected XmlRpcWriter getXmlRpcWriter(XmlRpcStreamRequestConfig pConfig, OutputStream pStream) throws XmlRpcException {
        ContentHandler w = this.getXMLWriterFactory().getXmlWriter(pConfig, pStream);
        return new XmlRpcWriter(pConfig, w, this.getTypeFactory());
    }

    protected void writeResponse(XmlRpcStreamRequestConfig pConfig, OutputStream pStream, Object pResult) throws XmlRpcException {
        try {
            this.getXmlRpcWriter(pConfig, pStream).write(pConfig, pResult);
        }
        catch (SAXException e) {
            throw new XmlRpcException("Failed to write XML-RPC response: " + e.getMessage(), e);
        }
    }

    protected void writeError(XmlRpcStreamRequestConfig pConfig, OutputStream pStream, Throwable pError) throws XmlRpcException {
        int code;
        if (pError instanceof XmlRpcException) {
            XmlRpcException ex = (XmlRpcException)pError;
            code = ex.code;
        } else {
            code = 0;
        }
        String message = pError.getMessage();
        try {
            this.getXmlRpcWriter(pConfig, pStream).write(pConfig, code, message);
        }
        catch (SAXException e) {
            throw new XmlRpcException("Failed to write XML-RPC response: " + e.getMessage(), e);
        }
    }

    public void setXMLWriterFactory(XmlWriterFactory pFactory) {
        this.writerFactory = pFactory;
    }

    public XmlWriterFactory getXMLWriterFactory() {
        return this.writerFactory;
    }

    protected abstract InputStream newInputStream(XmlRpcStreamRequestConfig var1, Object var2) throws IOException;

    protected InputStream getInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws IOException {
        InputStream istream = this.newInputStream(pConfig, pConnection);
        if (pConfig.isEnabledForExtensions() && pConfig.isGzipCompressing()) {
            istream = new GZIPInputStream(istream);
        }
        return istream;
    }

    protected abstract OutputStream newOutputStream(XmlRpcStreamRequestConfig var1, Object var2) throws IOException;

    protected OutputStream getOutputStream(XmlRpcStreamRequestConfig pConfig, OutputStream pStream) throws IOException {
        if (pConfig.isEnabledForExtensions() && pConfig.isGzipRequesting()) {
            return new GZIPOutputStream(pStream);
        }
        return pStream;
    }

    protected OutputStream getOutputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection, int pSize) throws IOException {
        return this.newOutputStream(pConfig, pConnection);
    }

    protected boolean isContentLengthRequired(XmlRpcStreamRequestConfig pConfig) {
        return false;
    }

    protected abstract void closeConnection(Object var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws IOException, XmlRpcException {
        XmlRpcStreamServer.log.debug((Object)"execute: ->");
        try {
            block37: {
                istream = null;
                try {
                    istream = this.getInputStream(pConfig, pConnection);
                    request = this.getRequest(pConfig, istream);
                    result = this.execute(request);
                    istream.close();
                    istream = null;
                    error = null;
                    XmlRpcStreamServer.log.debug((Object)"execute: Request performed successfully");
                    var8_9 = null;
                    ** if (istream == null) goto lbl-1000
                }
                catch (Throwable var7_13) {
                    var8_10 = null;
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    throw var7_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        istream.close();
                    }
                    catch (Throwable ignore) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block37;
                    catch (Throwable t) {
                        XmlRpcStreamServer.log.error((Object)"execute: Error while performing request", t);
                        result = null;
                        error = t;
                        var8_9 = null;
                        if (istream != null) {
                            try {
                                istream.close();
                            }
                            catch (Throwable ignore) {}
                        }
                    }
                }
            }
            if (contentLengthRequired = this.isContentLengthRequired(pConfig)) {
                baos = new ByteArrayOutputStream();
                ostream = baos;
            } else {
                baos = null;
                ostream = this.newOutputStream(pConfig, pConnection);
            }
            ostream = this.getOutputStream(pConfig, ostream);
            try {
                if (var4_8 == null) {
                    this.writeResponse(pConfig, ostream, var3_7);
                } else {
                    this.writeError(pConfig, ostream, (Throwable)var4_8);
                }
                ostream.close();
                ostream = null;
                var11_15 = null;
                ** if (ostream == null) goto lbl-1000
            }
            catch (Throwable var10_19) {
                var11_16 = null;
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                throw var10_19;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    ostream.close();
                }
                catch (Throwable ignore) {}
            }
lbl-1000:
            // 2 sources

            {
            }
            if (baos != null) {
                dest = this.getOutputStream(pConfig, pConnection, baos.size());
                try {
                    baos.writeTo(dest);
                    dest.close();
                    dest = null;
                    var14_20 = null;
                    ** if (dest == null) goto lbl-1000
                }
                catch (Throwable var13_24) {
                    var14_21 = null;
                    if (dest != null) {
                        try {
                            dest.close();
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    throw var13_24;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        dest.close();
                    }
                    catch (Throwable ignore) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            this.closeConnection(pConnection);
            pConnection = null;
            var17_25 = null;
            ** if (pConnection == null) goto lbl-1000
        }
        catch (Throwable var16_29) {
            var17_26 = null;
            if (pConnection != null) {
                try {
                    this.closeConnection(pConnection);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            throw var16_29;
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.closeConnection(pConnection);
            }
            catch (Throwable ignore) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        XmlRpcStreamServer.log.debug((Object)"execute: <-");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        spf.setNamespaceAware(true);
        spf.setValidating(false);
    }
}

