/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.xmlrpc.webserver.HttpServletResponseImpl;

class ServletOutputStreamImpl
extends ServletOutputStream {
    private final OutputStream target;
    private final HttpServletResponseImpl res;
    private final byte[] buffer = new byte[8192];
    private int bufferOffset;
    private boolean closed;
    private boolean committed;

    ServletOutputStreamImpl(OutputStream pTarget, HttpServletResponseImpl pResponse) {
        this.target = pTarget;
        this.res = pResponse;
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("This output stream is already closed.");
        }
        if (this.bufferOffset == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.bufferOffset++] = (byte)b;
    }

    public void write(byte[] pChars, int pOffset, int pLen) throws IOException {
        if (this.closed) {
            throw new IOException("This output stream is already closed.");
        }
        while (pLen-- > 0) {
            if (this.bufferOffset == this.buffer.length) {
                this.flush();
            }
            this.buffer[this.bufferOffset++] = pChars[pOffset++];
        }
    }

    private void flush(boolean pClosing) throws IOException {
        if (!this.committed) {
            this.committed = true;
            String headers = this.res.getHttpHeaders(pClosing ? new Integer(this.bufferOffset) : null);
            this.target.write(headers.getBytes("US-ASCII"));
        }
        if (this.bufferOffset > 0) {
            this.target.write(this.buffer, 0, this.bufferOffset);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.flush(true);
            this.closed = true;
            this.target.close();
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream is already closed.");
        }
        this.flush(false);
        this.target.flush();
    }

    void reset() {
        if (this.committed) {
            throw new IllegalStateException("The response is already committed. A reset cannot be performed.");
        }
    }

    boolean isCommitted() {
        return this.committed;
    }
}

