/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox;

import com.thoughtworks.qdox.Searcher;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.ModelBuilder;
import com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.thoughtworks.qdox.parser.impl.Parser;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.parser.structs.FieldDef;
import com.thoughtworks.qdox.parser.structs.MethodDef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class JavaDocBuilder
implements Serializable,
JavaClassCache {
    private Map classes = new HashMap();
    private ClassLibrary classLibrary;
    private List sources = new ArrayList();
    private DocletTagFactory docletTagFactory;
    private String encoding = System.getProperty("file.encoding");

    public JavaDocBuilder() {
        this(new DefaultDocletTagFactory());
    }

    public JavaDocBuilder(DocletTagFactory docletTagFactory) {
        this.docletTagFactory = docletTagFactory;
        this.classLibrary = new ClassLibrary(this);
        this.classLibrary.addDefaultLoader();
    }

    private void addClasses(JavaSource source) {
        HashSet resultSet = new HashSet();
        this.addClassesRecursive(source, resultSet);
        JavaClass[] javaClasses = resultSet.toArray(new JavaClass[resultSet.size()]);
        for (int classIndex = 0; classIndex < javaClasses.length; ++classIndex) {
            JavaClass cls = javaClasses[classIndex];
            this.addClass(cls);
        }
    }

    private void addClass(JavaClass cls) {
        this.classes.put(cls.getFullyQualifiedName(), cls);
        cls.setJavaClassCache(this);
    }

    public JavaClass getClassByName(String name) {
        if (name == null) {
            return null;
        }
        JavaClass result = (JavaClass)this.classes.get(name);
        if (result == null && (result = this.createBinaryClass(name)) != null) {
            this.addClass(result);
        }
        return result;
    }

    private JavaClass createBinaryClass(String name) {
        Class<?> anInterface;
        Class clazz = this.classLibrary.getClass(name);
        if (clazz == null) {
            return null;
        }
        ModelBuilder binaryBuilder = new ModelBuilder(this.classLibrary, this.docletTagFactory);
        String packageName = this.getPackageName(name);
        binaryBuilder.addPackage(packageName);
        ClassDef classDef = new ClassDef();
        classDef.name = this.getClassName(name);
        Class<?>[] interfaces = clazz.getInterfaces();
        if (clazz.isInterface()) {
            classDef.isInterface = true;
            for (int i = 0; i < interfaces.length; ++i) {
                anInterface = interfaces[i];
                classDef.extendz.add(anInterface.getName());
            }
        } else {
            for (int i = 0; i < interfaces.length; ++i) {
                anInterface = interfaces[i];
                classDef.implementz.add(anInterface.getName());
            }
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                classDef.extendz.add(superclass.getName());
            }
        }
        this.addModifiers(classDef.modifiers, clazz.getModifiers());
        binaryBuilder.beginClass(classDef);
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            this.addMethodOrConstructor(constructors[i], binaryBuilder);
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getDeclaringClass() != clazz) continue;
            this.addMethodOrConstructor(methods[i], binaryBuilder);
        }
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getDeclaringClass() != clazz) continue;
            this.addField(fields[i], binaryBuilder);
        }
        binaryBuilder.endClass();
        JavaSource binarySource = binaryBuilder.getSource();
        JavaClass result = binarySource.getClasses()[0];
        return result;
    }

    private void addModifiers(Set set, int modifier) {
        String modifierString = Modifier.toString(modifier);
        StringTokenizer stringTokenizer = new StringTokenizer(modifierString);
        while (stringTokenizer.hasMoreTokens()) {
            set.add(stringTokenizer.nextToken());
        }
    }

    private void addField(Field field, ModelBuilder binaryBuilder) {
        FieldDef fieldDef = new FieldDef();
        Class<?> fieldType = field.getType();
        fieldDef.name = field.getName();
        fieldDef.type = JavaDocBuilder.getTypeName(fieldType);
        fieldDef.dimensions = JavaDocBuilder.getDimension(fieldType);
        binaryBuilder.addField(fieldDef);
    }

    private void addMethodOrConstructor(Member member, ModelBuilder binaryBuilder) {
        int j;
        Class<?>[] parameterTypes;
        Class<?>[] exceptions;
        MethodDef methodDef = new MethodDef();
        int lastDot = member.getName().lastIndexOf(46);
        methodDef.name = member.getName().substring(lastDot + 1);
        this.addModifiers(methodDef.modifiers, member.getModifiers());
        if (member instanceof Method) {
            methodDef.constructor = false;
            exceptions = ((Method)member).getExceptionTypes();
            parameterTypes = ((Method)member).getParameterTypes();
            Class<?> returnType = ((Method)member).getReturnType();
            methodDef.returns = JavaDocBuilder.getTypeName(returnType);
            methodDef.dimensions = JavaDocBuilder.getDimension(returnType);
        } else {
            methodDef.constructor = true;
            exceptions = ((Constructor)member).getExceptionTypes();
            parameterTypes = ((Constructor)member).getParameterTypes();
        }
        for (j = 0; j < exceptions.length; ++j) {
            Class<?> exception = exceptions[j];
            methodDef.exceptions.add(exception.getName());
        }
        for (j = 0; j < parameterTypes.length; ++j) {
            FieldDef param = new FieldDef();
            Class<?> parameterType = parameterTypes[j];
            param.name = "p" + j;
            param.type = JavaDocBuilder.getTypeName(parameterType);
            param.dimensions = JavaDocBuilder.getDimension(parameterType);
            methodDef.params.add(param);
        }
        binaryBuilder.addMethod(methodDef);
    }

    private static final int getDimension(Class c) {
        return c.getName().lastIndexOf(91) + 1;
    }

    private static String getTypeName(Class c) {
        return c.getComponentType() != null ? c.getComponentType().getName() : c.getName();
    }

    private String getPackageName(String fullClassName) {
        int lastDot = fullClassName.lastIndexOf(46);
        return lastDot == -1 ? "" : fullClassName.substring(0, lastDot);
    }

    private String getClassName(String fullClassName) {
        int lastDot = fullClassName.lastIndexOf(46);
        return lastDot == -1 ? fullClassName : fullClassName.substring(lastDot + 1);
    }

    public JavaSource addSource(Reader reader) {
        ModelBuilder builder = new ModelBuilder(this.classLibrary, this.docletTagFactory);
        JFlexLexer lexer = new JFlexLexer(reader);
        Parser parser = new Parser(lexer, builder);
        parser.parse();
        JavaSource source = builder.getSource();
        this.sources.add(source);
        this.addClasses(source);
        return source;
    }

    public JavaSource addSource(File file) throws UnsupportedEncodingException, FileNotFoundException {
        JavaSource source = this.addSource(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
        source.setFile(file);
        source.setEncoding(this.encoding);
        return source;
    }

    public JavaSource[] getSources() {
        return this.sources.toArray(new JavaSource[this.sources.size()]);
    }

    public JavaClass[] getClasses() {
        HashSet resultSet = new HashSet();
        JavaSource[] javaSources = this.getSources();
        for (int i = 0; i < javaSources.length; ++i) {
            JavaSource javaSource = javaSources[i];
            this.addClassesRecursive(javaSource, resultSet);
        }
        JavaClass[] result = resultSet.toArray(new JavaClass[resultSet.size()]);
        return result;
    }

    private void addClassesRecursive(JavaSource javaSource, Set resultSet) {
        JavaClass[] classes = javaSource.getClasses();
        for (int j = 0; j < classes.length; ++j) {
            JavaClass javaClass = classes[j];
            this.addClassesRecursive(javaClass, resultSet);
        }
    }

    private void addClassesRecursive(JavaClass javaClass, Set set) {
        set.add(javaClass);
        JavaClass[] innerClasses = javaClass.getInnerClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            JavaClass innerClass = innerClasses[i];
            this.addClassesRecursive(innerClass, set);
        }
    }

    public void addSourceTree(File file) {
        DirectoryScanner scanner = new DirectoryScanner(file);
        scanner.addFilter(new SuffixFilter(".java"));
        scanner.scan(new FileVisitor(){

            public void visitFile(File currentFile) {
                try {
                    JavaDocBuilder.this.addSource(currentFile);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Cannot read file : " + currentFile.getName());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unsupported encoding : " + JavaDocBuilder.this.encoding);
                }
            }
        });
    }

    public List search(Searcher searcher) {
        LinkedList<JavaClass> results = new LinkedList<JavaClass>();
        Iterator iterator = this.classLibrary.all().iterator();
        while (iterator.hasNext()) {
            String clsName = (String)iterator.next();
            JavaClass cls = this.getClassByName(clsName);
            if (!searcher.eval(cls)) continue;
            results.add(cls);
        }
        return results;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        try {
            out.writeObject(this);
        }
        finally {
            out.close();
            fos.close();
        }
    }

    public static JavaDocBuilder load(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fis);
        JavaDocBuilder builder = null;
        try {
            builder = (JavaDocBuilder)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new Error("Couldn't load class : " + e.getMessage());
        }
        finally {
            in.close();
            fis.close();
        }
        return builder;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

