/*
 * Decompiled with CFR 0.152.
 */
package dart.server;

import dart.server.Container;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class Database {
    static Logger logger = Logger.getLogger(class$dart$server$Database == null ? (class$dart$server$Database = Database.class$("dart.server.Database")) : class$dart$server$Database);
    PoolingDataSource dataSource = null;
    Container owner = null;
    String driver = "derby";
    String url = null;
    String shutdownURL = null;
    String username = "Default";
    String password = "Default";
    int maxActive = 10;
    int maxIdle = 3;
    Connection connection = null;
    GenericObjectPool connectionPool = null;
    static /* synthetic */ Class class$dart$server$Database;

    public void setDriver(String driverclass) {
        this.driver = driverclass;
    }

    public void setURL(String connectionurl) {
        this.url = connectionurl;
    }

    public void setShutdownURL(String u) {
        this.shutdownURL = u;
    }

    public void setUsername(String name) {
        this.username = name;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public void setMaxActive(String max) {
        this.maxActive = Integer.parseInt(max);
    }

    public void setMaxIdle(String idle) {
        this.maxIdle = Integer.parseInt(idle);
    }

    public void start(Container p) throws Exception {
        this.owner = p;
        logger.debug(p.getTitle() + ": Starting database");
        try {
            Class.forName(this.driver);
            this.connectionPool = new GenericObjectPool(null);
            this.connectionPool.setMaxActive(this.maxActive);
            this.connectionPool.setMaxIdle(this.maxIdle);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.url, this.username, this.password);
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, this.connectionPool, null, null, false, true);
            this.dataSource = new PoolingDataSource(this.connectionPool);
            this.connectionPool.setTimeBetweenEvictionRunsMillis(240000L);
            this.connectionPool.setMinEvictableIdleTimeMillis(240000L);
        }
        catch (Exception e) {
            logger.error(this.owner.getTitle() + ": Failed to connect to database via: " + this.url + " driver: " + this.driver, e);
            throw e;
        }
    }

    public void shutdown() throws Exception {
        if (this.shutdownURL != null) {
            try {
                DriverManager.getConnection(this.shutdownURL);
            }
            catch (Exception e) {
                logger.info(this.owner.getTitle() + ": Caught exception, if this is a derby database, this is normal");
            }
        }
    }

    public Connection getConnection() {
        try {
            if (this.connectionPool.getMaxActive() - this.connectionPool.getNumActive() < 2) {
                logger.warn(this.owner.getTitle() + ": getConnection Connection pool nearly exhausted  " + this.connectionPool.getNumActive() + " of " + this.connectionPool.getMaxActive() + " currently active ");
            }
            logger.debug(this.owner.getTitle() + ": getConnection " + this.connectionPool.getNumActive() + " active " + this.connectionPool.getNumIdle() + " idle ");
            Connection connection = this.dataSource.getConnection();
            logger.debug(this.owner.getTitle() + ": got connection");
            return connection;
        }
        catch (Exception e) {
            logger.error(this.owner.getTitle() + ": Failed to get connection", e);
            return null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.connectionPool != null) {
            buffer.append("Database: " + this.connectionPool.getNumActive() + " active " + this.connectionPool.getNumIdle() + " idle ");
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

