/*
 * Decompiled with CFR 0.152.
 */
package dart.server;

import dart.server.Project;
import dart.server.TestProxy;
import dart.server.util.Base64;
import dart.server.wrap.ClientEntity;
import dart.server.wrap.ClientFinderBase;
import dart.server.wrap.ResultEntity;
import dart.server.wrap.ResultFinderBase;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestList;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import net.sourceforge.jaxor.EntityNotFoundException;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import org.apache.log4j.Logger;

public class TestProcessor {
    static Logger logger = Logger.getLogger(class$dart$server$TestProcessor == null ? (class$dart$server$TestProcessor = TestProcessor.class$("dart.server.TestProcessor")) : class$dart$server$TestProcessor);
    Project project = null;
    SubmissionEntity submission = null;
    ClientEntity client = null;
    String BuildName = null;
    Timestamp timestamp = null;
    String Type = null;
    String Site = null;
    String Generator = null;
    HashMap repeated = new HashMap();
    boolean foundSubmission = false;
    int maxTests = -1;
    int testsProcessed = 0;
    boolean delayProcessing = false;
    Vector pending = new Vector();
    static /* synthetic */ Class class$dart$server$TestProcessor;

    public TestProcessor(Project p) {
        this.project = p;
        logger.debug("Creating TestProcessor for " + this.project.getTitle());
    }

    public void setMaxTests(int t) {
        this.maxTests = t;
    }

    public void setDelayProcessing(boolean d) {
        this.delayProcessing = d;
    }

    public void setDelayProcessing(String d) {
        logger.debug("setDelayProcessing to " + d);
        this.delayProcessing = Boolean.valueOf(d);
    }

    public void setDelayProcessingOn() {
        this.delayProcessing = true;
    }

    public void setDelayProcessingOff() {
        this.delayProcessing = false;
    }

    public void setSite(String name) {
        this.Site = name;
        logger.debug("setSite: " + this.Site);
    }

    public void setBuildname(String buildname) {
        this.BuildName = buildname;
        logger.debug("setBuildName: " + this.BuildName);
    }

    public void setBuildstamp(String buildstamp) {
        logger.debug(this.project.getTitle() + ": Setting buildstamp " + buildstamp);
        this.timestamp = new Timestamp(this.project.parseBuildStamp(buildstamp).getTime());
        if (this.Type == null) {
            this.Type = buildstamp.substring(14);
        }
        logger.debug("setTimeStamp: " + this.timestamp);
        logger.debug("setType: " + this.Type);
    }

    public void setGenerator(String generator) {
        logger.debug(this.project.getTitle() + ": Setting generator " + generator);
        this.Generator = generator;
    }

    public void setDateTimeStamp(String stamp) {
        logger.debug("Setting DateTimeStamp");
        this.timestamp = new Timestamp(this.project.parseBuildStamp(stamp).getTime());
        if (this.Type == null) {
            this.Type = stamp.substring(14);
        }
        logger.debug("setTimeStamp: " + this.timestamp);
        logger.debug("setType: " + this.Type);
    }

    public void setTrack(String t) {
        this.Type = t;
    }

    public void queueSummary() {
        if (this.submission != null) {
            Iterator rollup = this.project.getRollups().iterator();
            while (rollup.hasNext()) {
                Object[] d = (Object[])rollup.next();
                String type = (String)d[0];
                int priority = Integer.parseInt((String)d[1]);
                Properties prop = new Properties((Properties)d[2]);
                prop.setProperty("SubmissionId", this.submission.getSubmissionId().toString());
                prop.setProperty("TrackName", this.submission.getType().toString());
                logger.debug(this.project.getTitle() + ": Queuing Rollup: " + type + " Priority: " + priority + " Properties: \n" + prop);
                this.project.queueTask(type, prop, priority);
            }
            this.project.setStatistic("LastActivity", new Date().toString());
        }
    }

    public void addChild(TestProxy proxy) {
        if (this.BuildName == null) {
            this.delayProcessing = true;
        }
        if (this.delayProcessing) {
            this.pending.add(proxy);
        } else {
            this.processTestProxy(proxy);
        }
    }

    public void processDelayed() {
        Iterator i = this.pending.iterator();
        while (i.hasNext()) {
            this.processTestProxy((TestProxy)i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTestProxy(TestProxy proxy) {
        if (this.testsProcessed > this.maxTests) {
            logger.info(this.project.getTitle() + ": Reached maximum tests: " + this.maxTests);
            return;
        }
        ++this.testsProcessed;
        if (proxy.getChildren() != null) {
            Iterator children = proxy.getChildren().iterator();
            while (children.hasNext()) {
                this.processTestProxy((TestProxy)children.next());
            }
        }
        Connection connection = this.project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        QueryParams q = null;
        logger.debug("Processing test: " + proxy.getQualifiedName());
        try {
            TestEntity test;
            if (this.client == null) {
                ClientFinderBase clientFinder = new ClientFinderBase(session);
                q = new QueryParams();
                q.add(this.BuildName);
                q.add(this.Site);
                try {
                    logger.debug("Seaching for " + this.BuildName + " / " + this.Site);
                    this.client = clientFinder.findUnique("where BuildName = ? and Site = ?", q, false);
                }
                catch (EntityNotFoundException notfound) {
                    logger.debug("Creating new Client instance: " + this.BuildName + " / " + this.Site);
                    this.client = clientFinder.newInstance();
                    this.client.setBuildName(this.BuildName);
                    this.client.setSite(this.Site);
                    session.commit();
                    this.client = clientFinder.findUnique("where BuildName = ? and Site = ?", q, false);
                    logger.debug("New Client instance: " + this.client.getClientId());
                }
            }
            if (this.submission == null) {
                SubmissionFinderBase submissionFinder = new SubmissionFinderBase(session);
                q = new QueryParams();
                q.add(this.client.getClientId());
                q.add(this.timestamp);
                q.add(this.Type);
                try {
                    this.submission = submissionFinder.findUnique("where ClientId = ? and Timestamp = ? and Type = ?", q, false);
                }
                catch (EntityNotFoundException notfound) {
                    logger.debug("Creating new Submission instance: " + this.timestamp + " - " + this.Type);
                    this.submission = submissionFinder.newInstance();
                    this.submission.setTimeStamp(this.timestamp);
                    this.submission.setClientId(this.client.getClientId());
                    this.submission.setType(this.Type);
                    this.submission.setGenerator(this.Generator);
                    this.submission.setStatus("InProgress");
                    session.commit();
                    this.submission = submissionFinder.findUnique("where ClientId = ? and Timestamp = ? and Type = ?", q, false);
                    logger.debug("New Submission: " + this.submission.getSubmissionId());
                }
            }
            TestFinderBase testFinder = new TestFinderBase(session);
            q = new QueryParams();
            q.add(this.submission.getSubmissionId());
            q.add(proxy.getQualifiedName());
            logger.debug("Testname: " + proxy.getQualifiedName());
            try {
                if (proxy.isRepeated()) {
                    int id = 0;
                    String Name2 = proxy.getQualifiedName();
                    boolean done = false;
                    while (!done) {
                        q = new QueryParams();
                        q.add(this.submission.getSubmissionId());
                        q.add(proxy.getQualifiedName());
                        TestList l = testFinder.find("where SubmissionId = ? and QualifiedName = ?", q);
                        if (l.size() == 0) {
                            done = true;
                            continue;
                        }
                        proxy.setQualifiedNameNoReplace(Name2 + id);
                        ++id;
                    }
                }
                q = new QueryParams();
                q.add(this.submission.getSubmissionId());
                q.add(proxy.getQualifiedName());
                test = testFinder.findUnique("where SubmissionId = ? and QualifiedName = ?", q, false);
                if (!proxy.allowDuplicates()) {
                    logger.debug("Duplicate Test in DB, ignoring. " + proxy.getQualifiedName());
                    return;
                }
            }
            catch (EntityNotFoundException notfound) {
                test = testFinder.newInstance();
                test.setSubmissionId(this.submission.getSubmissionId());
                test.setQualifiedName(proxy.getQualifiedName());
                String[] n = proxy.getQualifiedName().split("\\.");
                test.setName(n[n.length - 1]);
                test.setStatus(proxy.getStatus());
                session.commit();
                test = testFinder.findUnique("where SubmissionId = ? and QualifiedName = ?", q, false);
            }
            this.submission.setCreatedTimeStamp(new Timestamp(Calendar.getInstance().getTimeInMillis()));
            if (proxy.getStatus().equals("f")) {
                test.setStatus(proxy.getStatus());
            }
            ResultFinderBase resultFinder = new ResultFinderBase(session);
            Iterator i = proxy.getResultMap().keySet().iterator();
            while (i.hasNext()) {
                ResultEntity result;
                String name = (String)i.next();
                String[] s = (String[])proxy.getResultMap().get(name);
                String type = s[0];
                String value = s[1];
                boolean compress = false;
                try {
                    q = new QueryParams();
                    q.add(name);
                    q.add(test.getTestId());
                    result = resultFinder.findUnique("where Name = ? and TestId = ?", q, false);
                }
                catch (EntityNotFoundException notfound) {
                    result = resultFinder.newInstance();
                }
                result.setName(name);
                result.setType(type);
                result.setTestId(test.getTestId());
                logger.debug("Set TestId: " + test.getTestId());
                if (Project.isLargeDataType(type)) {
                    FilterOutputStream out;
                    String suffix = ".txt.gz";
                    byte[] bytes = value.getBytes();
                    compress = true;
                    if (type.equals("text/xml")) {
                        suffix = ".xml.gz";
                        compress = true;
                    } else if (type.equals("image/png")) {
                        suffix = ".png";
                        compress = false;
                        logger.debug(this.project.getTitle() + ": Base64 decoding result");
                        bytes = Base64.decode(bytes, 0, bytes.length);
                    } else if (type.equals("image/jpeg")) {
                        suffix = ".jpeg";
                        compress = false;
                        logger.debug(this.project.getTitle() + ": Base64 decoding result");
                        bytes = Base64.decode(bytes, 0, bytes.length);
                    } else if (type.equals("archive/zip")) {
                        suffix = ".zip";
                        compress = false;
                        logger.debug(this.project.getTitle() + ": Base64 decoding archive/zip");
                        bytes = Base64.decode(bytes, 0, bytes.length);
                    }
                    if (compress) {
                        int count;
                        logger.debug(this.project.getTitle() + ": compressing result");
                        ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes());
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        out = new GZIPOutputStream(bout);
                        byte[] buffer = new byte[1024];
                        while ((count = in.read(buffer)) != -1) {
                            ((GZIPOutputStream)out).write(buffer, 0, count);
                        }
                        ((GZIPOutputStream)out).finish();
                        bytes = bout.toByteArray();
                    }
                    File output = this.project.generateProjectRelativeFileForBinary(bytes, suffix);
                    File abs = new File(this.project.getDataDirectory(), output.getPath());
                    abs.getParentFile().mkdirs();
                    result.setValue(output.getPath());
                    if (abs.exists()) continue;
                    logger.debug("Creating new file: " + abs);
                    out = new BufferedOutputStream(new FileOutputStream(abs));
                    ((OutputStream)out).write(bytes);
                    ((OutputStream)out).flush();
                    continue;
                }
                if (value.length() > 2000) {
                    logger.warn(this.project.getTitle() + ": Truncating Value > 2000 characters, " + test.getQualifiedName() + " / " + result.getName());
                    value = value.substring(0, 1999);
                }
                result.setValue(value);
            }
            session.commit();
            this.project.incrementStatistic("TestsProcessed");
        }
        catch (Exception e) {
            logger.error("Failed to process Test", e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {}
        }
    }

    public void setCruiseControlInfo(String name, String value) {
        logger.debug("setCruiseControlInfo: " + name + " = " + value);
        if (name != null && name.equals("builddate")) {
            this.setBuildstamp(value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

