/*
 * Decompiled with CFR 0.152.
 */
package dart.server;

import dart.server.Project;
import dart.server.track.Track;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.SubmissionList;
import dart.server.wrap.TrackEntity;
import dart.server.wrap.TrackFinderBase;
import dart.server.wrap.TrackIterator;
import dart.server.wrap.TrackList;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class TrackManager {
    static Logger logger = Logger.getLogger(class$dart$server$TrackManager == null ? (class$dart$server$TrackManager = TrackManager.class$("dart.server.TrackManager")) : class$dart$server$TrackManager);
    Project project;
    HashMap map = new HashMap();
    String defaultTrack;
    static /* synthetic */ Class class$dart$server$TrackManager;

    public void addTrack(Track t) {
        logger.debug("Adding Track: " + t);
        this.map.put(t.getName(), t);
        if (t.getPriority() == 100L) {
            t.setPriority(this.map.size());
        }
    }

    public void setDefaultTrack(String s) {
        this.defaultTrack = s;
    }

    public String getDefaultTrack() {
        return this.defaultTrack;
    }

    public void start(Project p) throws Exception {
        this.project = p;
        logger.debug(this.project.getTitle() + ": Starting TrackManager");
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            Track track = (Track)i.next();
            track.setProject(this.project);
        }
    }

    public HashMap getTracks() {
        return this.map;
    }

    public String[] getTrackOrder() {
        ArrayList trackObjectList = new ArrayList();
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            trackObjectList.add(it.next().getValue());
        }
        Object[] trackObjectArray = trackObjectList.toArray();
        Arrays.sort(trackObjectArray, new CompareTrackPriority());
        String[] trackorder = new String[trackObjectArray.length];
        for (int i = 0; i < trackObjectArray.length; ++i) {
            trackorder[i] = ((Track)trackObjectArray[i]).getName();
        }
        return trackorder;
    }

    public long getTrackId(Timestamp ts, String trackName) {
        return ((Track)this.map.get(trackName)).getTrackId(ts);
    }

    public long[] getTrackIds(Timestamp ts) {
        long[] r = new long[this.map.size()];
        Iterator i = this.map.values().iterator();
        int idx = 0;
        while (i.hasNext()) {
            Track track = (Track)i.next();
            r[idx] = track.getTrackId(ts);
            ++idx;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkSubmission(long SubmissionId) throws Exception {
        Connection connection = this.project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        try {
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(session);
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(SubmissionId));
            SubmissionList l = submission.selectLastSubmissions();
            if (l.size() > 0) {
                SubmissionEntity lastEntity = l.get(0);
                lastEntity.setNextSubmissionId(submission.getSubmissionId());
                submission.setLastSubmissionId(lastEntity.getSubmissionId());
            }
            if ((l = submission.selectNextSubmissions()).size() > 0) {
                SubmissionEntity nextEntity = l.get(0);
                nextEntity.setLastSubmissionId(submission.getSubmissionId());
                submission.setNextSubmissionId(nextEntity.getSubmissionId());
            }
            session.commit();
        }
        catch (Exception e) {
            logger.error("Failed to link Submission: " + SubmissionId);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexTracks() {
        Connection connection = this.project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        TrackFinderBase trackFinder = new TrackFinderBase(session);
        try {
            TrackList list = trackFinder.findAll();
            TrackIterator i = list.iterator();
            while (i.hasNext()) {
                TrackEntity trackEntity = i.next();
                Track track = (Track)this.map.get(trackEntity.getName());
                boolean deleteTrack = false;
                if (track == null) {
                    deleteTrack = true;
                } else {
                    SubmissionList submissionList = trackEntity.getSubmissionList();
                    if (submissionList.size() == 0) {
                        deleteTrack = true;
                    } else if (!track.isValidTrack(trackEntity)) {
                        deleteTrack = true;
                    }
                }
                if (!deleteTrack) continue;
                logger.debug("Track is invalid: " + trackEntity.getTrackId());
                Properties prop = new Properties();
                prop.setProperty("TrackId", trackEntity.getTrackId().toString());
                this.project.queueTask("dart.server.task.DeleteTrackTask", prop, 10);
            }
            session.commit();
        }
        catch (Exception e) {
            logger.error("Failed to link valid Tracks ", e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception ex) {}
        }
    }

    public void placeSubmission(long SubmissionId, String trackName) throws Exception {
        this.linkSubmission(SubmissionId);
        Track track = (Track)this.map.get(trackName);
        if (track == null) {
            track = (Track)this.map.get(this.defaultTrack);
        }
        if (track == null) {
            String e = this.project.getTitle() + ": not able to place submission, Track " + trackName + " was not found";
            logger.error(e);
            throw new Exception(e);
        }
        if (!track.placeSubmission(SubmissionId)) {
            String e = this.project.getTitle() + ": failed to place submission, SubmissionId " + SubmissionId;
            logger.error(e);
            throw new Exception(e);
        }
    }

    public void shutdown() throws Exception {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CompareTrackPriority
    implements Comparator {
        CompareTrackPriority() {
        }

        public int compare(Object o1, Object o2) {
            long p2;
            long p1 = ((Track)o1).getPriority();
            if (p1 < (p2 = ((Track)o2).getPriority())) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }
    }
}

