/*
 * Decompiled with CFR 0.152.
 */
package dart.server.servlet;

import dart.server.Project;
import dart.server.Server;
import dart.server.StatusFormat;
import dart.server.wrap.ClientEntity;
import dart.server.wrap.ClientFinderBase;
import dart.server.wrap.ResultList;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestIterator;
import dart.server.wrap.TestList;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.mappers.IntegerMapper;
import net.sourceforge.jaxor.mappers.StringMapper;
import net.sourceforge.jaxor.mappers.TimestampMapper;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class ChartServlet
extends HttpServlet {
    static Logger logger = Logger.getLogger(class$dart$server$servlet$ChartServlet == null ? (class$dart$server$servlet$ChartServlet = ChartServlet.class$("dart.server.servlet.ChartServlet")) : class$dart$server$servlet$ChartServlet);
    static /* synthetic */ Class class$dart$server$servlet$ChartServlet;
    static /* synthetic */ Class class$org$jfree$data$time$Minute;

    void error(PrintWriter out, String title, String msg, HashMap map) {
        String projectName = (String)map.get("projectName");
        out.println("<html><head><title>" + title + "</title></head>");
        out.println("<body>");
        out.println("<h1>Chart for ");
        out.println(projectName);
        out.println("</h1>");
        out.println("<p>");
        out.println(msg);
        out.println("<p>");
        out.println("</body>");
        out.println("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block56: {
            Connection connection;
            ServletOutputStream out;
            block55: {
                block54: {
                    String[] values;
                    Project project;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("request", req);
                    map.put("response", res);
                    out = res.getOutputStream();
                    map.put("out", out);
                    String projectName = this.getInitParameter("project");
                    map.put("projectName", projectName);
                    try {
                        project = Server.getProject(projectName);
                        if (project == null) {
                            logger.debug(project.getTitle() + ": not found");
                            out.close();
                            return;
                        }
                    }
                    catch (Exception e) {
                        logger.debug(projectName + ": error getting project");
                        out.close();
                        return;
                    }
                    map.put("project", project);
                    Map parameters = req.getParameterMap();
                    connection = null;
                    JFreeChart chart = null;
                    String type = "time";
                    if (parameters.containsKey("type")) {
                        values = (String[])parameters.get("type");
                        type = values[0];
                    }
                    int history = 1;
                    if (type.equals("time") && parameters.containsKey("history")) {
                        values = (String[])parameters.get("history");
                        history = new Integer(values[0]);
                    }
                    String measurement = "Execution Time";
                    if (parameters.containsKey("measurement")) {
                        values = (String[])parameters.get("measurement");
                        measurement = values[0];
                    }
                    String title = "";
                    if (parameters.containsKey("title")) {
                        values = (String[])parameters.get("title");
                        title = values[0];
                    }
                    String xlabel = "";
                    if (parameters.containsKey("xlabel")) {
                        values = (String[])parameters.get("xlabel");
                        xlabel = values[0];
                    }
                    String ylabel = "";
                    if (parameters.containsKey("ylabel")) {
                        values = (String[])parameters.get("ylabel");
                        ylabel = values[0];
                    }
                    String legend = "test";
                    if (parameters.containsKey("legend")) {
                        values = (String[])parameters.get("legend");
                        legend = values[0];
                    }
                    int width = 400;
                    if (parameters.containsKey("width")) {
                        values = (String[])parameters.get("width");
                        width = new Integer(values[0]);
                    }
                    int height = 300;
                    if (parameters.containsKey("height")) {
                        values = (String[])parameters.get("height");
                        height = new Integer(values[0]);
                    }
                    connection = project.getConnection();
                    try {
                        connection.setReadOnly(true);
                    }
                    catch (Exception e) {
                        logger.error(project.getTitle() + ": Could not set connection to ReadOnly, possible security hole!", e);
                    }
                    JaxorContextImpl jaxorContext = new JaxorContextImpl(connection);
                    SubmissionFinderBase submissionFinder = new SubmissionFinderBase(jaxorContext);
                    ClientFinderBase clientFinder = new ClientFinderBase(jaxorContext);
                    TestFinderBase testFinder = new TestFinderBase(jaxorContext);
                    if (parameters.containsKey("submissionid") && parameters.containsKey("testname")) {
                        TimeSeriesCollection data = new TimeSeriesCollection();
                        String[] submissionids = (String[])parameters.get("submissionid");
                        Float minValue = new Float(Float.POSITIVE_INFINITY);
                        Float maxValue = new Float(Float.NEGATIVE_INFINITY);
                        for (int j = 0; j < submissionids.length; ++j) {
                            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(submissionids[j]));
                            String submissionType = submission.getType();
                            Timestamp submissionTimeStamp = submission.getTimeStamp();
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(submissionTimeStamp);
                            calendar.add(5, -history);
                            Timestamp lowerTimeStamp = new Timestamp(calendar.getTimeInMillis());
                            Long clientId = submission.getClientId();
                            ClientEntity client = clientFinder.selectByClientId(clientId);
                            String[] testnames = (String[])parameters.get("testname");
                            for (int i = 0; i < testnames.length; ++i) {
                                Minute time;
                                Timestamp testTimeStamp;
                                TestEntity test;
                                String testname = testnames[i];
                                QueryParams qp = new QueryParams();
                                qp.add(new IntegerMapper(), (Object)clientId);
                                qp.add(new StringMapper(), (Object)submissionType);
                                qp.add(new TimestampMapper(), (Object)submissionTimeStamp);
                                qp.add(new TimestampMapper(), (Object)lowerTimeStamp);
                                qp.add(new StringMapper(), (Object)testname);
                                TestList testList = testFinder.query("select Test.* from Test,Submission where Test.SubmissionId = Submission.SubmissionId and Submission.ClientId = ? and Submission.Type = ? and Submission.TimeStamp <= ? and Submission.TimeStamp >= ? and Test.QualifiedName = ? order by Submission.TimeStamp", qp);
                                String seriesTitle = submissionids.length > 1 && testnames.length > 1 ? submission.getSite() + "-" + submission.getBuildName() + "-" + submissionType + "-" + testname : (submissionids.length > 1 ? submission.getSite() + "-" + submission.getBuildName() + "-" + submissionType : (testnames.length > 1 ? testname : (legend.equals("test") ? testname : (legend.equals("submission") ? submission.getSite() + "-" + submission.getBuildName() + "-" + submissionType : testname))));
                                TimeSeries series = new TimeSeries(seriesTitle, class$org$jfree$data$time$Minute == null ? ChartServlet.class$("org.jfree.data.time.Minute") : class$org$jfree$data$time$Minute);
                                TestIterator it = testList.iterator();
                                if (measurement.equals("PassedSubTests")) {
                                    while (it.hasNext()) {
                                        test = it.next();
                                        testTimeStamp = test.getSubmissionEntity().getTimeStamp();
                                        time = new Minute(testTimeStamp);
                                        series.add((RegularTimePeriod)time, test.getPassedSubTests());
                                    }
                                } else if (measurement.equals("FailedSubTests")) {
                                    while (it.hasNext()) {
                                        test = it.next();
                                        testTimeStamp = test.getSubmissionEntity().getTimeStamp();
                                        time = new Minute(testTimeStamp);
                                        series.add((RegularTimePeriod)time, test.getFailedSubTests());
                                    }
                                } else if (measurement.equals("NotRunSubTests")) {
                                    while (it.hasNext()) {
                                        test = it.next();
                                        testTimeStamp = test.getSubmissionEntity().getTimeStamp();
                                        time = new Minute(testTimeStamp);
                                        series.add((RegularTimePeriod)time, test.getNotRunSubTests());
                                    }
                                } else if (measurement.equals("Status")) {
                                    while (it.hasNext()) {
                                        test = it.next();
                                        testTimeStamp = test.getSubmissionEntity().getTimeStamp();
                                        time = new Minute(testTimeStamp);
                                        series.add((RegularTimePeriod)time, test.getStatusAsNumber());
                                    }
                                } else {
                                    while (it.hasNext()) {
                                        test = it.next();
                                        ResultList results = test.selectResult(measurement);
                                        if (results.size() <= 0) continue;
                                        Timestamp testTimeStamp2 = test.getSubmissionEntity().getTimeStamp();
                                        Minute time2 = new Minute(testTimeStamp2);
                                        Float value = new Float(results.get(0).getValue());
                                        series.add((RegularTimePeriod)time2, value);
                                        if (value.compareTo(minValue) < 0) {
                                            minValue = value;
                                        }
                                        if (value.compareTo(maxValue) <= 0) continue;
                                        maxValue = value;
                                    }
                                }
                                data.addSeries(series);
                            }
                        }
                        if (type.equals("time")) {
                            chart = ChartFactory.createTimeSeriesChart(title, xlabel, ylabel, data, true, false, false);
                            XYItemRenderer r = chart.getXYPlot().getRenderer();
                            if (r instanceof XYLineAndShapeRenderer) {
                                XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
                                renderer.setBaseShapesVisible(true);
                                renderer.setBaseShapesFilled(false);
                            }
                            NumberFormat rangeFormat = NumberFormat.getNumberInstance();
                            NumberAxis rangeAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
                            rangeAxis.setNumberFormatOverride(rangeFormat);
                            if ((double)(maxValue.floatValue() - minValue.floatValue()) < 2.0) {
                                float fudge = 0.1f;
                                rangeAxis.setAutoRange(false);
                                rangeAxis.setLowerBound((double)minValue.floatValue() * (1.0 - (double)fudge));
                                rangeAxis.setUpperBound((double)maxValue.floatValue() * (1.0 + (double)fudge));
                            } else {
                                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                            }
                            if (measurement.equals("Status")) {
                                rangeAxis.setAutoRange(false);
                                rangeAxis.setLowerBound(-1.1);
                                rangeAxis.setUpperBound(1.1);
                                rangeAxis.setAutoTickUnitSelection(false);
                                rangeAxis.setTickUnit(new NumberTickUnit(1.0));
                                StatusFormat statusFormat = new StatusFormat();
                                rangeAxis.setNumberFormatOverride(statusFormat);
                            }
                        } else if (type.equals("bar")) {
                            chart = ChartFactory.createXYBarChart(title, xlabel, true, ylabel, data, PlotOrientation.VERTICAL, data.getSeriesCount() > 1, false, false);
                        } else if (type.equals("area")) {
                            chart = ChartFactory.createTimeSeriesChart(title, xlabel, ylabel, data, true, false, false);
                            XYBarRenderer rbar = new XYBarRenderer();
                            XYStepAreaRenderer rsa = new XYStepAreaRenderer();
                            chart.getXYPlot().setRenderer(rsa);
                        } else if (type.equals("step")) {
                            chart = ChartFactory.createXYStepChart(title, xlabel, ylabel, data, PlotOrientation.VERTICAL, data.getSeriesCount() > 1, false, false);
                        }
                        if (chart != null) {
                            chart.setBackgroundPaint(new Color(176, 196, 222));
                            DateAxis axis = (DateAxis)chart.getXYPlot().getDomainAxis();
                            axis.setDateFormatOverride(new SimpleDateFormat("MMM dd, yyyy"));
                        }
                    }
                    if (chart != null) {
                        res.setContentType("image/png");
                        ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
                        ChartUtilities.writeChartAsPNG(out, chart, width, height, info);
                        break block54;
                    }
                    logger.info("No chart created.");
                }
                Object var50_57 = null;
                if (connection == null) break block55;
                try {
                    connection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            out.close();
            {
                break block56;
                catch (Exception e) {
                    logger.error("Exception caught: " + e, e);
                    Object var50_58 = null;
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    out.close();
                }
            }
            catch (Throwable throwable) {
                Object var50_59 = null;
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                out.close();
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

