/*
 * Decompiled with CFR 0.152.
 */
package dart.server.servlet;

import dart.server.Project;
import dart.server.Server;
import dart.server.wrap.UserEntity;
import dart.server.wrap.UserFinderBase;
import dart.server.wrap.UserPropertyEntity;
import dart.server.wrap.UserPropertyFinderBase;
import dart.server.wrap.UserPropertyIterator;
import dart.server.wrap.UserPropertyList;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.jaxor.EntityNotFoundException;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.mappers.LongMapper;
import net.sourceforge.jaxor.mappers.StringMapper;
import net.sourceforge.jaxor.util.SystemException;
import org.apache.log4j.Logger;
import org.mortbay.http.UserRealm;

public class User
extends HttpServlet {
    static Logger logger = Logger.getLogger(class$dart$server$Server == null ? (class$dart$server$Server = User.class$("dart.server.Server")) : class$dart$server$Server);
    static /* synthetic */ Class class$dart$server$Server;

    void error(PrintWriter out, String title, String msg, HashMap map) {
        String projectName = (String)map.get("projectName");
        out.println("<html><head><title>" + title + "</title></head>");
        out.println("<body>");
        out.println("<h1>Dart User");
        out.println("</h1>");
        out.println("<p>");
        out.println(msg);
        out.println("<p>");
        out.println("</body>");
        out.println("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Template template;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("request", req);
        map.put("response", res);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("referer", req.getHeader("Referer"));
        Map parameters = req.getParameterMap();
        root.put("parameters", parameters);
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            HttpSessionHashModel httpSessionModel = new HttpSessionHashModel(httpSession, ObjectWrapper.DEFAULT_WRAPPER);
            root.put("session", httpSessionModel);
        }
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        map.put("out", out);
        String templateName = null;
        String serverName = null;
        String projectName = null;
        try {
            projectName = this.getInitParameter("project");
            if (projectName != null) {
                Project project = Server.getProject(projectName);
                serverName = project.getServer().getTitle();
                root.put("projectName", projectName);
            }
            Configuration cfg = new Configuration();
            File resourcesDirectory = new File(Server.getServer(serverName).getBaseDirectory(), "Templates");
            cfg.setDirectoryForTemplateLoading(resourcesDirectory);
            templateName = req.getPathInfo();
            template = cfg.getTemplate(templateName + ".ftl");
        }
        catch (Exception e) {
            logger.error("Failed to find template", e);
            this.error(out, "Dart User", "Dart: Failed to find or parse template: \"" + templateName + "\"", map);
            out.close();
            return;
        }
        Server server = Server.getServer(serverName);
        Connection connection = server.getConnection();
        JaxorContextImpl dbSession = new JaxorContextImpl(connection);
        UserFinderBase userFinder = new UserFinderBase(dbSession);
        if (httpSession != null) {
            UserEntity user = null;
            Principal principal = (Principal)httpSession.getAttribute("user");
            if (principal != null) {
                try {
                    user = userFinder.selectByEmail(principal.getName());
                    if (user != null) {
                        root.put("user", user);
                    }
                }
                catch (EntityNotFoundException notfound) {
                    logger.warn("User not found");
                }
            } else {
                logger.warn("No authenticated user");
            }
        } else {
            logger.warn("No session available, cannot track user.");
        }
        if (parameters.get("Logout") != null) {
            Principal principal = (Principal)httpSession.getAttribute("user");
            if (principal != null) {
                logger.info("User \"" + principal.getName() + "\" logging out.");
                UserRealm realm = server.getHttpServer().getRealm("Dart");
                realm.logout(principal);
                if (httpSession != null) {
                    httpSession.setAttribute("user", null);
                    httpSession.setAttribute("Email", null);
                    httpSession.setAttribute("First", null);
                    httpSession.setAttribute("Last", null);
                    httpSession.setAttribute("DisplayName", null);
                    httpSession.invalidate();
                }
            }
            try {
                connection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            res.sendRedirect(req.getHeader("Referer"));
            out.close();
            return;
        }
        UserRealm realm = server.getHttpServer().getRealm("Dart");
        BeansWrapper realmWrapper = new BeansWrapper();
        realmWrapper.setExposureLevel(0);
        try {
            root.put("realm", realmWrapper.wrap(realm));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            template.process(root, out);
        }
        catch (Exception e) {
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {}
        }
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String projectName;
        Map parameters = req.getParameterMap();
        String command = req.getPathInfo();
        String serverName = this.getInitParameter("server");
        if (serverName == null && (projectName = this.getInitParameter("project")) != null) {
            Project project = Server.getProject(projectName);
            serverName = project.getServer().getTitle();
        }
        Server server = Server.getServer(serverName);
        UserRealm realm = server.getHttpServer().getRealm("Dart");
        HttpSession httpSession = req.getSession();
        if (httpSession != null) {
            httpSession.setAttribute("Email", null);
            httpSession.setAttribute("First", null);
            httpSession.setAttribute("Last", null);
        }
        if (parameters.get("Login") != null) {
            logger.info("User \"" + ((String[])parameters.get("Email"))[0] + "\" logging in.");
            if (parameters.get("Email") != null) {
                Principal principal = realm.authenticate(((String[])parameters.get("Email"))[0], ((String[])parameters.get("Password"))[0], null);
                if (principal != null) {
                    logger.info("User \"" + principal + "\" authenticated.");
                    if (httpSession != null) {
                        httpSession.setAttribute("user", principal);
                        Connection connection = server.getConnection();
                        JaxorContextImpl dbSession = new JaxorContextImpl(connection);
                        UserFinderBase userFinder = new UserFinderBase(dbSession);
                        UserEntity user = userFinder.selectByEmail(principal.getName());
                        if (user != null) {
                            httpSession.setAttribute("DisplayName", user.getFirstName());
                            UserPropertyList upl = user.getUserPropertyList();
                            UserPropertyIterator upit = upl.iterator();
                            UserPropertyEntity up = null;
                            while (upit.hasNext()) {
                                up = upit.next();
                                if (!up.getName().equals("PlotDuration")) continue;
                                httpSession.setAttribute("PlotDuration", up.getValue());
                            }
                        }
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        res.sendRedirect(req.getContextPath() + req.getServletPath() + "/User");
                    } else {
                        logger.warn("User \"" + ((String[])parameters.get("Email"))[0] + "\" authenticated but could not be tracked.");
                        if (httpSession != null) {
                            httpSession.setAttribute("Email", ((String[])parameters.get("Email"))[0]);
                        }
                        res.sendRedirect(req.getRequestURI() + "?error=1");
                    }
                } else {
                    logger.warn("User \"" + ((String[])parameters.get("Email"))[0] + "\" could not be authenticated.");
                    if (httpSession != null) {
                        httpSession.setAttribute("Email", ((String[])parameters.get("Email"))[0]);
                    }
                    res.sendRedirect(req.getRequestURI() + "?error=2");
                }
            }
        } else if (parameters.get("CreateUser") != null) {
            UserEntity user;
            logger.info("Creating new user account");
            String msg = "";
            String msgSpacer = "";
            if (httpSession == null) {
                msg = msg + msgSpacer + "error=1";
                msgSpacer = "&";
            }
            Connection connection = server.getConnection();
            JaxorContextImpl dbSession = new JaxorContextImpl(connection);
            UserFinderBase userFinder = new UserFinderBase(dbSession);
            if (parameters.get("Email") != null) {
                user = null;
                try {
                    user = userFinder.selectByEmail(((String[])parameters.get("Email"))[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (user != null) {
                    logger.warn("Cannot create user account. User already exists.");
                    msg = msg + msgSpacer + "error=3";
                    msgSpacer = "&";
                    if (httpSession != null) {
                        httpSession.setAttribute("Email", ((String[])parameters.get("Email"))[0]);
                    }
                }
            }
            if (parameters.get("Email") == null || ((String[])parameters.get("Email"))[0].equals("")) {
                msg = msg + msgSpacer + "error=4";
                msgSpacer = "&";
            } else if (httpSession != null) {
                httpSession.setAttribute("Email", ((String[])parameters.get("Email"))[0]);
            }
            if (parameters.get("Password") == null || ((String[])parameters.get("Password"))[0].equals("")) {
                msg = msg + msgSpacer + "error=5";
                msgSpacer = "&";
            }
            if (parameters.get("Retype") == null || ((String[])parameters.get("Retype"))[0].equals("")) {
                msg = msg + msgSpacer + "error=6";
                msgSpacer = "&";
            }
            if (parameters.get("Password") != null && parameters.get("Retype") != null && !((String[])parameters.get("Password"))[0].equals(((String[])parameters.get("Retype"))[0])) {
                msg = msg + msgSpacer + "error=7";
                msgSpacer = "&";
            }
            if (parameters.get("First") == null || ((String[])parameters.get("First"))[0].equals("")) {
                msg = msg + msgSpacer + "error=8";
                msgSpacer = "&";
            } else if (httpSession != null) {
                httpSession.setAttribute("First", ((String[])parameters.get("First"))[0]);
            }
            if (parameters.get("Last") == null || ((String[])parameters.get("Last"))[0].equals("")) {
                msg = msg + msgSpacer + "error=9";
                msgSpacer = "&";
            } else if (httpSession != null) {
                httpSession.setAttribute("Last", ((String[])parameters.get("Last"))[0]);
            }
            if (!msg.equals("")) {
                res.sendRedirect(req.getRequestURI() + "?" + msg);
            } else {
                logger.info("User information validated. Creating user.");
                user = userFinder.newInstance();
                user.setEmail(((String[])parameters.get("Email"))[0]);
                user.setPassword(((String[])parameters.get("Password"))[0]);
                user.setFirstName(((String[])parameters.get("First"))[0]);
                user.setLastName(((String[])parameters.get("Last"))[0]);
                user.setActive("1");
                try {
                    dbSession.commit();
                }
                catch (SystemException e) {
                    logger.error("Failed to create user. " + e.getCauseList());
                }
                user = userFinder.selectByEmail(((String[])parameters.get("Email"))[0]);
                logger.info("User committed.");
                Principal principal = realm.authenticate(((String[])parameters.get("Email"))[0], ((String[])parameters.get("Password"))[0], null);
                if (principal != null) {
                    if (httpSession != null) {
                        httpSession.setAttribute("user", principal);
                        res.sendRedirect(req.getContextPath() + req.getServletPath() + "/User");
                        logger.info("User authenticated.");
                    }
                } else {
                    logger.warn("Cannot authenticate user");
                }
            }
            try {
                connection.close();
            }
            catch (Exception e) {}
        } else if (parameters.get("UpdateUser") != null) {
            logger.info("Modifying a user account");
            String msg = "";
            String msgSpacer = "";
            Connection connection = server.getConnection();
            JaxorContextImpl dbSession = new JaxorContextImpl(connection);
            UserFinderBase userFinder = new UserFinderBase(dbSession);
            Principal principal = (Principal)httpSession.getAttribute("user");
            UserEntity user = userFinder.selectByEmail(principal.getName());
            boolean passwordModified = false;
            boolean firstNameModified = false;
            boolean lastNameModified = false;
            httpSession.setAttribute("Email", principal.getName());
            if (parameters.get("Password") != null && parameters.get("Retype") != null && !user.getPassword().equals(((String[])parameters.get("Password"))[0])) {
                if (!((String[])parameters.get("Password"))[0].equals(((String[])parameters.get("Retype"))[0])) {
                    msg = msg + msgSpacer + "error=1";
                    msgSpacer = "&";
                } else {
                    passwordModified = true;
                }
            }
            if (parameters.get("First") == null || ((String[])parameters.get("First"))[0].equals("")) {
                msg = msg + msgSpacer + "error=2";
                msgSpacer = "&";
            } else if (!user.getFirstName().equals(((String[])parameters.get("First"))[0])) {
                firstNameModified = true;
            }
            if (parameters.get("Last") == null || ((String[])parameters.get("Last"))[0].equals("")) {
                msg = msg + msgSpacer + "error=3";
                msgSpacer = "&";
            } else if (!user.getLastName().equals(((String[])parameters.get("Last"))[0])) {
                lastNameModified = true;
            }
            if (!msg.equals("")) {
                res.sendRedirect(req.getRequestURI() + "?" + msg);
            } else {
                logger.info("User information validated. Modifying user.");
                if (passwordModified) {
                    user.setPassword(((String[])parameters.get("Password"))[0]);
                }
                if (firstNameModified) {
                    user.setFirstName(((String[])parameters.get("First"))[0]);
                    httpSession.setAttribute("First", ((String[])parameters.get("First"))[0]);
                }
                if (lastNameModified) {
                    user.setLastName(((String[])parameters.get("Last"))[0]);
                    httpSession.setAttribute("Last", ((String[])parameters.get("Last"))[0]);
                }
                try {
                    dbSession.commit();
                }
                catch (SystemException e) {
                    logger.error("Failed to modify user. " + e.getCauseList());
                }
                user = userFinder.selectByEmail(principal.getName());
                logger.info("Logging out " + principal.getName());
                realm.logout(principal);
                logger.info("Principal = " + principal);
                principal = realm.authenticate(user.getEmail(), user.getPassword(), null);
                if (principal != null) {
                    if (httpSession != null) {
                        httpSession.setAttribute("user", principal);
                        res.sendRedirect(req.getContextPath() + req.getServletPath() + "/User");
                        logger.info("User authenticated.");
                    }
                } else {
                    logger.warn("Cannot authenticate user. " + principal + ", " + user);
                }
            }
            try {
                connection.close();
            }
            catch (Exception e) {}
        } else if (parameters.get("AddRepositoryId") != null) {
            logger.info("Adding a repository id");
            Connection connection = server.getConnection();
            JaxorContextImpl dbSession = new JaxorContextImpl(connection);
            UserFinderBase userFinder = new UserFinderBase(dbSession);
            UserPropertyFinderBase userPropertyFinder = new UserPropertyFinderBase(dbSession);
            Principal principal = (Principal)httpSession.getAttribute("user");
            UserEntity user = userFinder.selectByEmail(principal.getName());
            if (parameters.get("ProjectName") != null && parameters.get("RepositoryId") != null) {
                UserPropertyEntity property = userPropertyFinder.newInstance();
                property.setUserId(user.getUserId());
                property.setName(((String[])parameters.get("ProjectName"))[0] + ".RepositoryId");
                property.setValue(((String[])parameters.get("RepositoryId"))[0]);
                try {
                    dbSession.commit();
                }
                catch (SystemException e) {
                    logger.error("Failed to update repository ids. " + e.getCauseList());
                }
                UserPropertyList properties = user.getUserPropertyList();
            }
            try {
                connection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            res.sendRedirect(req.getContextPath() + req.getServletPath() + "/User");
        } else if (parameters.get("RemoveRepositoryId") != null) {
            logger.info("Removing a repository id");
            Connection connection = server.getConnection();
            JaxorContextImpl dbSession = new JaxorContextImpl(connection);
            UserFinderBase userFinder = new UserFinderBase(dbSession);
            UserPropertyFinderBase userPropertyFinder = new UserPropertyFinderBase(dbSession);
            Principal principal = (Principal)httpSession.getAttribute("user");
            UserEntity user = userFinder.selectByEmail(principal.getName());
            if (parameters.get("ProjectName") != null && parameters.get("RepositoryId") != null) {
                QueryParams qc = new QueryParams();
                qc.add(new LongMapper(), (Object)user.getUserId());
                qc.add(new StringMapper(), (Object)(((String[])parameters.get("ProjectName"))[0] + ".RepositoryId"));
                qc.add(new StringMapper(), (Object)((String[])parameters.get("RepositoryId"))[0]);
                UserPropertyList propertyList = userPropertyFinder.find("where userid=? and name=? and value=?", qc);
                if (propertyList.size() > 0) {
                    UserPropertyEntity p = (UserPropertyEntity)propertyList.toList().get(0);
                    p.delete();
                }
                try {
                    dbSession.commit();
                }
                catch (SystemException e) {
                    logger.error("Failed to update repository ids. " + e.getCauseList());
                }
                UserPropertyList properties = user.getUserPropertyList();
            }
            try {
                connection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            res.sendRedirect(req.getContextPath() + req.getServletPath() + "/User");
        } else if (parameters.get("Logout") != null) {
            Principal principal = (Principal)httpSession.getAttribute("user");
            if (principal != null) {
                logger.info("User \"" + principal.getName() + "\" logging out.");
                realm.logout(principal);
                if (httpSession != null) {
                    httpSession.setAttribute("user", null);
                    httpSession.setAttribute("Email", null);
                    httpSession.setAttribute("First", null);
                    httpSession.setAttribute("Last", null);
                    httpSession.setAttribute("DisplayName", null);
                    httpSession.invalidate();
                }
            }
            res.sendRedirect(req.getContextPath() + req.getServletPath() + "/UserLogin");
        } else {
            logger.warn("Dart User: unknown action");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

