/*
 * Decompiled with CFR 0.152.
 */
package dart.server.servlet;

import dart.server.Project;
import dart.server.Server;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ZipServlet
extends HttpServlet {
    static Logger logger = Logger.getLogger(class$dart$server$servlet$ZipServlet == null ? (class$dart$server$servlet$ZipServlet = ZipServlet.class$("dart.server.servlet.ZipServlet")) : class$dart$server$servlet$ZipServlet);
    static /* synthetic */ Class class$dart$server$servlet$ZipServlet;

    void error(HttpServletResponse res, String title, String msg) throws IOException {
        PrintWriter out = res.getWriter();
        out.println("<html><head><title>" + title + "</title></head>");
        out.println("<body>");
        out.println("<p>");
        out.println(msg);
        out.println("<p>");
        out.println("</body>");
        out.println("</html>");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Closeable out;
        String templateName = req.getPathInfo();
        if (templateName.endsWith(".zip")) {
            res.sendRedirect(req.getRequestURL() + "/index.html");
            return;
        }
        logger.debug("Looking for " + templateName);
        String[] split = templateName.split(".zip");
        String entryName = null;
        String zipfile = null;
        if (split.length == 1) {
            zipfile = split[0] + ".zip";
            entryName = "index.html";
        } else {
            zipfile = split[0] + ".zip";
            entryName = split[1].substring(1);
        }
        String projectName = this.getInitParameter("project");
        Project project = Server.getProject(projectName);
        if (project == null) {
            this.error(res, "Invalid project", "The project \"" + projectName + "\" was not found");
            return;
        }
        logger.debug("Opening: " + project.getDataDirectory().getPath() + zipfile);
        ZipFile zip = new ZipFile(project.getDataDirectory().getPath() + zipfile);
        if (zip == null) {
            this.error(res, "Invalid zip", "Unable to open the zip file: " + zipfile);
            return;
        }
        ZipEntry entry = zip.getEntry(entryName);
        logger.debug("Looking for: " + entryName);
        if (entry == null) {
            this.error(res, "Invalid entry", "Unable to find " + entryName + " inside the zip file");
            return;
        }
        String type = null;
        String lower = entryName.toLowerCase();
        int idx = lower.lastIndexOf(".");
        if (idx != -1) {
            String suffix = lower.substring(idx);
            type = this.getInitParameter(suffix);
        }
        if (type == null) {
            type = "text/html";
        }
        logger.debug("Setting content type to " + type);
        res.setContentType(type);
        if (type.startsWith("text")) {
            out = res.getWriter();
            BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
            while (true) {
                int s = 1;
                char[] buffer = new char[2048];
                s = in.read(buffer);
                if (s == -1) break;
                ((PrintWriter)out).write(buffer, 0, s);
            }
            ((PrintWriter)out).close();
        } else {
            out = res.getOutputStream();
            BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
            while (true) {
                int s = 1;
                byte[] buffer = new byte[2048];
                s = ((InputStream)in).read(buffer);
                if (s == -1) break;
                ((OutputStream)out).write(buffer, 0, s);
            }
            ((OutputStream)out).close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

