/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Container;
import dart.server.Project;
import dart.server.servlet.Base64Encode;
import dart.server.servlet.FetchData;
import dart.server.task.Task;
import dart.server.wrap.ClientEntity;
import dart.server.wrap.ResultEntity;
import dart.server.wrap.ResultIterator;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.SubmissionIterator;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestIterator;
import dart.server.wrap.TrackEntity;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import org.apache.log4j.Logger;

public class ArchiveTask
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$ArchiveTask == null ? (class$dart$server$task$ArchiveTask = ArchiveTask.class$("dart.server.task.ArchiveTask")) : class$dart$server$task$ArchiveTask);
    int MaxDirectorySizeMB = 700;
    String FileNamePattern = "Archive-%L-%P-%S-%B-%T-%D.xml.gz";
    String ArchiverList = "";
    int ArchiveLevel = 0;
    long ArchiveSizeInK = 0L;
    Connection connection;
    JaxorContextImpl session;
    QueryParams q = null;
    Project project = null;
    String TemplateName = "ArchiveSumbission.xml";
    File ArchiveDirectory = null;
    File Working = null;
    File Temporary = null;
    static /* synthetic */ Class class$dart$server$task$ArchiveTask;

    private void archiveSubmission(SubmissionEntity submission) throws Exception {
        File TempFile = File.createTempFile("ArchiveSubmission", ".xml.gz", this.Temporary);
        logger.debug("Starting to archive submission: " + submission.getSubmissionId());
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("fetchdata", new FetchData(this.project));
        root.put("base64encode", new Base64Encode());
        root.put("submission", submission);
        Configuration cfg = new Configuration();
        File resourcesDirectory = new File(this.project.getBaseDirectory(), "Templates");
        cfg.setDirectoryForTemplateLoading(resourcesDirectory);
        Template template = cfg.getTemplate(this.TemplateName);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(TempFile))));
        template.process(root, out);
        ((Writer)out).close();
        String ArchiveFileName = this.FileNamePattern;
        ArchiveFileName = ArchiveFileName.replaceAll("%L", Integer.toString(this.ArchiveLevel));
        ArchiveFileName = ArchiveFileName.replaceAll("%P", this.project.getTitle());
        ArchiveFileName = ArchiveFileName.replaceAll("%S", submission.getSite());
        ArchiveFileName = ArchiveFileName.replaceAll("%B", submission.getBuildName());
        ArchiveFileName = ArchiveFileName.replaceAll("%T", submission.getTrackEntity().getName());
        SimpleDateFormat format = new SimpleDateFormat(Container.UTCFormat);
        String ts = format.format(submission.getTimeStamp()).toString();
        ArchiveFileName = ArchiveFileName.replaceAll("%D", ts);
        ts = format.format(Calendar.getInstance().getTime()).toString();
        ArchiveFileName = ArchiveFileName.replaceAll("%N", ts);
        ArchiveFileName = Container.generateSafeFileName(ArchiveFileName);
        int l = (int)((double)TempFile.length() / 1000.0);
        if ((long)l + this.ArchiveSizeInK > (long)(this.MaxDirectorySizeMB * 1000)) {
            format = new SimpleDateFormat(Container.UTCFormat);
            ts = format.format(Calendar.getInstance().getTime()).toString();
            ts = Container.generateSafeFileName(ts);
            File newArchive = new File(this.ArchiveDirectory, ts);
            this.Working.renameTo(newArchive);
            this.Working.mkdirs();
            this.ArchiveSizeInK = 0L;
        }
        this.ArchiveSizeInK += (long)l;
        File destination = new File(this.Working, ArchiveFileName);
        logger.debug("Finished archiving submission");
        TempFile.renameTo(destination);
    }

    private void deleteTest(TestEntity test, boolean deleteNonBulkData) throws Exception {
        ResultIterator results = test.getResultList().iterator();
        while (results.hasNext()) {
            ResultEntity result = results.next();
            logger.debug("Deleting Result: " + result.getName());
            if (Project.isLargeDataType(result.getType())) {
                Properties prop = new Properties();
                prop.setProperty("ResultValue", result.getValue());
                prop.setProperty("RecordCompletedTask", "false");
                this.project.queueTask("dart.server.task.DeleteDataTask", prop, 100);
            }
            if (!deleteNonBulkData && !Project.isLargeDataType(result.getType())) continue;
            logger.debug("Doing delete");
            result.delete();
        }
        test.getJaxorContext().commit();
    }

    private boolean matches(String s, Pattern[] patterns) {
        logger.debug("Matching string: " + s);
        for (int i = 0; i < patterns.length; ++i) {
            logger.debug("\tMatching pattern: " + patterns[i].pattern());
            if (!patterns[i].matcher(s).matches()) continue;
            logger.debug("\tMatched!");
            return true;
        }
        return false;
    }

    private Pattern[] generatePatterns(String[] regexp) {
        Pattern[] patterns = new Pattern[regexp.length];
        for (int i = 0; i < regexp.length; ++i) {
            patterns[i] = Pattern.compile(regexp[i]);
        }
        return patterns;
    }

    private void synchronizedExecute(Project p, Properties properties) throws Exception {
        if (properties == null) {
            logger.warn("Null properties");
        }
        int SubmissionsToArchive = -1;
        int SubmissionsArchived = 0;
        SubmissionsToArchive = Integer.parseInt(properties.getProperty("SubmissionsToArchive", "-1"));
        this.project = p;
        logger.info(this.project.getTitle() + ": Starting Archive");
        SimpleDateFormat format = new SimpleDateFormat(Container.UTCFormat);
        String DirectoryName = format.format(Calendar.getInstance().getTime()).toString();
        logger.debug("DirectoryName: " + DirectoryName);
        this.connection = this.project.getConnection();
        this.session = new JaxorContextImpl(this.connection);
        SubmissionFinderBase submissionFinder = new SubmissionFinderBase(this.session);
        try {
            String[] Archivers = properties.getProperty("ArchiverList", "").split(",");
            block5: for (int ArchiverIdx = 0; ArchiverIdx < Archivers.length; ++ArchiverIdx) {
                String Archiver = Archivers[ArchiverIdx];
                logger.debug("Starting Archiver: " + Archiver);
                this.FileNamePattern = properties.getProperty("Archiver." + Archiver + ".FileNamePattern", "Archive-%P-%S-%B-%T-%D.xml.gz");
                this.TemplateName = properties.getProperty("Archiver." + Archiver + ".Template", "ArchiveSubmission.xml");
                String ArchiveBy = properties.getProperty("Archiver." + Archiver + ".ArchiveBy", "CreatedTimeStamp");
                if (!ArchiveBy.toLowerCase().equals("createdtimestamp") && !ArchiveBy.toLowerCase().equals("timestamp")) {
                    logger.error(this.project.getTitle() + ": ArchiveBy must be CreatedTimeStamp or TimeStamp, skipping this Archiver");
                    continue;
                }
                String dir = properties.getProperty("Archiver." + Archiver + ".ArchiveDirectory", null);
                this.ArchiveDirectory = dir == null || dir.equals("") ? p.getArchiveDirectory() : new File(dir);
                this.MaxDirectorySizeMB = Integer.parseInt(properties.getProperty("Archiver." + Archiver + ".MaxDirectorySizeMB", "700"));
                if (!this.ArchiveDirectory.exists() && !this.ArchiveDirectory.mkdirs()) {
                    logger.error("Failed to make directory: " + this.ArchiveDirectory.getPath());
                    throw new Exception("Failed to make directory: " + this.ArchiveDirectory.getPath());
                }
                this.Working = new File(this.ArchiveDirectory, "Working");
                this.Working.mkdirs();
                this.Temporary = new File(this.ArchiveDirectory, "Temporary");
                this.Temporary.mkdirs();
                File[] children = this.Working.listFiles();
                this.ArchiveSizeInK = 0L;
                for (int i = 0; i < children.length; ++i) {
                    this.ArchiveSizeInK += (long)((int)((double)children[i].length() / 1000.0));
                }
                logger.debug("Archive: " + Archiver + " ArchiveSizeInK: " + this.ArchiveSizeInK);
                String[] MatchTrack = properties.getProperty("Archiver." + Archiver + ".MatchTrack", ".*").split(",");
                String[] MatchTest = properties.getProperty("Archiver." + Archiver + ".MatchTest", ".*").split(",");
                String[] MatchSite = properties.getProperty("Archiver." + Archiver + ".MatchSite", ".*").split(",");
                String[] MatchBuildName = properties.getProperty("Archiver." + Archiver + ".MatchBuildName", ".*").split(",");
                String[] MatchRemove = properties.getProperty("Archiver." + Archiver + ".Remove", ".*").split(",");
                Pattern[] TrackPatterns = this.generatePatterns(MatchTrack);
                Pattern[] TestPatterns = this.generatePatterns(MatchTest);
                Pattern[] SitePatterns = this.generatePatterns(MatchSite);
                Pattern[] BuildNamePatterns = this.generatePatterns(MatchBuildName);
                Pattern[] RemovePatterns = this.generatePatterns(MatchRemove);
                float AgeInDays = Float.parseFloat(properties.getProperty("Archiver." + Archiver + ".AgeInDays", "-1.0"));
                if ((double)AgeInDays < 0.0) {
                    logger.debug(this.project.getTitle() + ": Archiver: " + Archiver + " has no AgeInDays");
                    continue;
                }
                this.ArchiveLevel = Integer.parseInt(properties.getProperty("Archiver." + Archiver + ".ArchiveLevel", "0"));
                boolean WriteArchive = Boolean.valueOf(properties.getProperty("Archiver." + Archiver + ".WriteArchive", "true"));
                Calendar age = Calendar.getInstance();
                age.add(12, (int)(-AgeInDays * 24.0f * 60.0f));
                this.q = new QueryParams();
                this.q.add(new Timestamp(age.getTimeInMillis()));
                this.q.add(this.ArchiveLevel);
                logger.debug("Age Timestamp: " + new Timestamp(age.getTimeInMillis()));
                SubmissionIterator submissions = submissionFinder.find("where " + ArchiveBy + " < ? and ArchiveLevel < ?", this.q).iterator();
                while (submissions.hasNext()) {
                    if (SubmissionsToArchive != -1 && SubmissionsArchived >= SubmissionsToArchive) {
                        logger.debug("Completed archive of " + SubmissionsArchived + " Submissions, break");
                        continue block5;
                    }
                    SubmissionEntity submission = submissions.next();
                    ClientEntity client = submission.getClientEntity();
                    TrackEntity track = submission.getTrackEntity();
                    logger.debug("Found submission: " + client.getSite() + " / " + client.getBuildName() + " @ " + submission.getTimeStamp());
                    logger.debug("CreatedTimeStamp: " + submission.getCreatedTimeStamp());
                    if (track == null || !this.matches(track.getName(), TrackPatterns)) {
                        logger.debug("Didn't match Track");
                        continue;
                    }
                    if (!this.matches(client.getSite(), SitePatterns)) {
                        logger.debug("Didn't match Site");
                        continue;
                    }
                    if (!this.matches(client.getBuildName(), BuildNamePatterns)) {
                        logger.debug("Didn't match BuildName");
                        continue;
                    }
                    Timestamp compareTS = submission.getCreatedTimeStamp();
                    if (submission.getArchivedTimeStamp() == null || submission.getArchivedTimeStamp().before(submission.getCreatedTimeStamp())) {
                        if (WriteArchive) {
                            this.archiveSubmission(submission);
                        }
                        submission.setArchivedTimeStamp(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                        this.session.commit();
                    }
                    logger.info("Archiving " + ++SubmissionsArchived + " of " + SubmissionsToArchive);
                    TestIterator tests = submission.getTestList().iterator();
                    while (tests.hasNext()) {
                        TestEntity test = tests.next();
                        logger.debug("Examining test: " + test.getQualifiedName());
                        if (!this.matches(test.getQualifiedName(), TestPatterns)) {
                            logger.debug("Test didn't match");
                            continue;
                        }
                        if (this.ArchiveLevel == 4) {
                            this.deleteTest(test, true);
                            logger.debug("Level 4 Deleting Test: " + test.getQualifiedName());
                            test.delete();
                            this.session.commit();
                            continue;
                        }
                        if (this.ArchiveLevel == 3) {
                            TestEntity Parent = test.selectParent();
                            if (Parent == null || Parent.getQualifiedName().equals("")) continue;
                            this.deleteTest(test, true);
                            logger.debug("Level 3 Deleting Test: " + test.getQualifiedName());
                            test.delete();
                            this.session.commit();
                            continue;
                        }
                        if (this.ArchiveLevel == 2) {
                            if (test.getStatus().equals("m")) continue;
                            this.deleteTest(test, true);
                            logger.debug("Level 2 Deleting Test: " + test.getQualifiedName());
                            test.delete();
                            this.session.commit();
                            continue;
                        }
                        if (this.ArchiveLevel != 1) continue;
                        this.deleteTest(test, false);
                    }
                    if (this.ArchiveLevel == 4) {
                        logger.debug("Deleting submission: " + client.getSite() + " / " + client.getBuildName() + " @ " + submission.getTimeStamp());
                        submission.delete();
                    } else {
                        submission.setArchiveLevel(new Integer(this.ArchiveLevel));
                    }
                    this.session.commit();
                }
            }
            this.session.commit();
        }
        catch (Exception e) {
            logger.error("Failed to Archive task", e);
            throw e;
        }
        finally {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Project project, Properties properties) throws Exception {
        logger.debug("Synchronizing on project");
        Object object = project.getLockObject(this.getClass().toString());
        synchronized (object) {
            logger.info("Lock acquiried, starting execute");
            this.synchronizedExecute(project, properties);
            logger.info("Finished execute, released lock");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

