/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.task.Task;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionIterator;
import dart.server.wrap.SubmissionList;
import dart.server.wrap.TrackEntity;
import dart.server.wrap.TrackFinderBase;
import dart.server.wrap.TrackList;
import java.sql.Connection;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class DeleteTrackTask
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$DeleteTrackTask == null ? (class$dart$server$task$DeleteTrackTask = DeleteTrackTask.class$("dart.server.task.DeleteTrackTask")) : class$dart$server$task$DeleteTrackTask);
    static /* synthetic */ Class class$dart$server$task$DeleteTrackTask;

    public void execute(Project project, Properties properties) throws Exception {
        Long TrackId = Long.valueOf(properties.getProperty("TrackId"));
        Connection connection = project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        try {
            logger.debug("Finding track: " + TrackId);
            TrackFinderBase trackFinder = new TrackFinderBase(session);
            TrackEntity track = trackFinder.selectByPrimaryKey(TrackId);
            Long LastTrackId = track.getLastTrackId();
            Long NextTrackId = track.getNextTrackId();
            TrackList list = null;
            if (NextTrackId != null && (list = track.selectNextTrackList()).size() > 0) {
                list.get(0).setLastTrackId(LastTrackId);
            }
            if (LastTrackId != null && (list = track.selectLastTrackList()).size() > 0) {
                list.get(0).setNextTrackId(LastTrackId);
            }
            SubmissionList submissionList = track.getSubmissionList();
            SubmissionIterator submissions = submissionList.iterator();
            while (submissions.hasNext()) {
                SubmissionEntity submission = submissions.next();
                submission.setTrackId(null);
                Properties prop = new Properties();
                prop.setProperty("SubmissionId", submission.getSubmissionId().toString());
                prop.setProperty("TrackName", submission.getType().toString());
                project.queueTask("dart.server.task.PlaceSubmissionInTrackTask", prop, 2);
                logger.debug("Queued PlaceSubmissionInTrackTask task for " + submission.getSubmissionId());
            }
            track.delete();
            session.commit();
        }
        catch (Exception e) {
            logger.error(project.getTitle() + ": Failed to place delete track", e);
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

