/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.event.MissingSubmissionEvent;
import dart.server.task.Task;
import dart.server.wrap.ClientEntity;
import dart.server.wrap.ClientFinderBase;
import dart.server.wrap.ClientIterator;
import dart.server.wrap.ClientList;
import dart.server.wrap.ClientPropertyEntity;
import dart.server.wrap.ClientPropertyFinderBase;
import dart.server.wrap.ClientPropertyIterator;
import dart.server.wrap.ClientPropertyList;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.SubmissionList;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class MissingSubmissionTask
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$MissingSubmissionTask == null ? (class$dart$server$task$MissingSubmissionTask = MissingSubmissionTask.class$("dart.server.task.MissingSubmissionTask")) : class$dart$server$task$MissingSubmissionTask);
    static /* synthetic */ Class class$dart$server$task$MissingSubmissionTask;

    public void execute(Project project, Properties properties) throws Exception {
        boolean missing = false;
        ArrayList<Long> clientIds = new ArrayList<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        Date date = new Date();
        Timestamp timeStamp = new Timestamp(date.getTime());
        String trackName = properties.getProperty("Track");
        Long trackId = new Long(project.getTrackManager().getTrackId(timeStamp, trackName));
        String expectedSubmissionKey = "Expected." + trackName;
        String expectedSubmissionUserKey = expectedSubmissionKey + ".Notify.UserId";
        Connection connection = project.getConnection();
        JaxorContextImpl dbSession = new JaxorContextImpl(connection);
        ClientFinderBase clientFinder = new ClientFinderBase(dbSession);
        ClientPropertyFinderBase clientPropertyFinder = new ClientPropertyFinderBase(dbSession);
        SubmissionFinderBase submissionFinder = new SubmissionFinderBase(dbSession);
        Connection serverConnection = project.getServer().getConnection();
        JaxorContextImpl serverDBSession = new JaxorContextImpl(serverConnection);
        ClientList clientList = clientFinder.selectByClientPropertyList(expectedSubmissionKey, "true");
        if (clientList.size() != 0) {
            ClientIterator cit = clientList.iterator();
            while (cit.hasNext()) {
                ClientEntity client = cit.next();
                Long clientId = client.getClientId();
                SubmissionList submissionList = submissionFinder.selectByClientIdAndTrackIdList(clientId, trackId);
                if (submissionList.size() != 0) continue;
                missing = true;
                clientIds.add(clientId);
                ClientPropertyEntity cp = null;
                ClientPropertyList who = clientPropertyFinder.selectByClientIdNameList(clientId, expectedSubmissionUserKey);
                if (who.size() == 0) continue;
                ClientPropertyIterator cpit = who.iterator();
                while (cpit.hasNext()) {
                    cp = cpit.next();
                    try {
                        Long userid = new Long(Long.parseLong(cp.getValue()));
                        userIds.add(userid);
                    }
                    catch (NumberFormatException exc) {}
                }
            }
        }
        if (missing) {
            MissingSubmissionEvent event = new MissingSubmissionEvent(clientIds, userIds, trackName, trackId);
            project.getListenerManager().triggerEvent(event);
        }
        try {
            connection.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            serverConnection.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

