/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.task.Task;
import dart.server.wrap.ResultEntity;
import dart.server.wrap.ResultFinderBase;
import dart.server.wrap.ResultList;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestIterator;
import java.sql.Connection;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class SummarizeBuildTask
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$SummarizeBuildTask == null ? (class$dart$server$task$SummarizeBuildTask = SummarizeBuildTask.class$("dart.server.task.SummarizeBuildTask")) : class$dart$server$task$SummarizeBuildTask);
    static /* synthetic */ Class class$dart$server$task$SummarizeBuildTask;

    public void execute(Project project, Properties properties) throws Exception {
        String SubmissionId = properties.getProperty("SubmissionId");
        Connection connection = project.getConnection();
        try {
            JaxorContextImpl session = new JaxorContextImpl(connection);
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(session);
            TestFinderBase testFinder = new TestFinderBase(session);
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(SubmissionId));
            TestEntity build = submission.selectTest(".Build");
            if (build == null) {
                logger.debug(project.getTitle() + ": No Build info found");
                return;
            }
            logger.debug(project.getTitle() + ": processing " + build.getQualifiedName());
            ResultFinderBase resultFinder = new ResultFinderBase(session);
            this.summarize_build(resultFinder, build);
            session.commit();
            session.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            connection.close();
        }
    }

    private int[] summarize_build(ResultFinderBase resultFinder, TestEntity build) {
        int[] TotalCounts = new int[]{0, 0};
        int SelfErrors = 0;
        int SelfWarnings = 0;
        float ElapsedTime = 0.0f;
        logger.debug("processing build " + build.getQualifiedName());
        TestIterator children = build.selectChildren().iterator();
        while (children.hasNext()) {
            TestEntity child = children.next();
            if (child.getQualifiedName().matches(".*Error[^.]*")) {
                ++SelfErrors;
            } else if (child.getQualifiedName().matches(".*Warning[^.]*")) {
                ++SelfWarnings;
            } else {
                int[] counts = this.summarize_build(resultFinder, child);
                TotalCounts[0] = TotalCounts[0] + counts[0];
                TotalCounts[1] = TotalCounts[1] + counts[1];
            }
            if (!build.getQualifiedName().equals(".Build")) continue;
            String t = child.getResultValue("ElapsedTime", "0.0");
            ElapsedTime += Float.parseFloat(t);
        }
        TotalCounts[0] = TotalCounts[0] + SelfErrors;
        TotalCounts[1] = TotalCounts[1] + SelfWarnings;
        this.set_result(resultFinder, build, "ErrorCount", TotalCounts[0]);
        this.set_result(resultFinder, build, "WarningCount", TotalCounts[1]);
        this.set_result(resultFinder, build, "SelfErrorCount", SelfErrors);
        this.set_result(resultFinder, build, "SelfWarningCount", SelfWarnings);
        if (build.getQualifiedName().equals(".Build")) {
            build.setResult("ElapsedTime", "numeric/float", "" + ElapsedTime);
        }
        return TotalCounts;
    }

    private void set_result(ResultFinderBase resultFinder, TestEntity test, String name, int value) {
        ResultList results = test.selectResult(name);
        if (results.toArray().length == 0) {
            logger.debug("Setting " + test.getQualifiedName() + "." + name + " to " + value);
            ResultEntity result = resultFinder.newInstance();
            result.setTestId(test.getTestId());
            result.setType("numeric/integer");
            result.setName(name);
            result.setValue(Integer.toString(value));
        } else if (results.toArray().length == 1) {
            ResultEntity result = results.toArray()[0];
            String valueStr = Integer.toString(value);
            if (!result.getValue().equals(valueStr)) {
                logger.debug("Updating " + test.getQualifiedName() + "." + name + " to " + valueStr);
                result.setValue(valueStr);
            } else {
                logger.debug(test.getQualifiedName() + "." + name + " is already " + valueStr);
            }
        } else {
            logger.error("Already multiple " + test.getQualifiedName() + "." + name);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

