/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.task.Task;
import dart.server.wrap.ResultEntity;
import dart.server.wrap.ResultIterator;
import dart.server.wrap.ResultList;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestIterator;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class SummarizeDynamicAnalysis
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$SummarizeDynamicAnalysis == null ? (class$dart$server$task$SummarizeDynamicAnalysis = SummarizeDynamicAnalysis.class$("dart.server.task.SummarizeDynamicAnalysis")) : class$dart$server$task$SummarizeDynamicAnalysis);
    JaxorContextImpl session;
    static /* synthetic */ Class class$dart$server$task$SummarizeDynamicAnalysis;

    protected void rollup(TestEntity test) {
        HashMap<String, Float> accumulatedResults = new HashMap<String, Float>();
        TestIterator children = test.selectChildren().iterator();
        while (children.hasNext()) {
            TestEntity child = children.next();
            this.rollup(child);
            ResultList results = child.getResultList();
            ResultIterator resultIt = results.iterator();
            while (resultIt.hasNext()) {
                Number sum;
                Number current;
                Number value;
                ResultEntity result = resultIt.next();
                String resultType = result.getType();
                String resultName = result.getName();
                if (!resultType.startsWith("numeric/")) continue;
                if (resultType.equals("numeric/integer")) {
                    logger.debug("Summarizing " + result.getName());
                    value = (Integer)child.getResultValueAsObject(resultName, new Integer(0));
                    current = new Integer(0);
                    if (accumulatedResults.containsKey(resultName)) {
                        current = (Integer)accumulatedResults.get(resultName);
                    }
                    sum = new Integer((Integer)current + (Integer)value);
                    accumulatedResults.put(resultName, (Float)sum);
                    logger.debug("Value = " + value + ", Current = " + current + ", Sum = " + sum);
                    continue;
                }
                if (!resultType.equals("numeric/float")) continue;
                value = (Float)child.getResultValueAsObject(resultName, new Float(0.0f));
                current = new Float(0.0f);
                if (accumulatedResults.containsKey(resultName)) {
                    current = (Float)accumulatedResults.get(resultName);
                }
                sum = new Float(((Float)current).intValue() + ((Float)value).intValue());
                accumulatedResults.put(resultName, (Float)sum);
            }
        }
        try {
            if (test.getStatus().equals("m")) {
                Iterator mapIt = accumulatedResults.entrySet().iterator();
                while (mapIt.hasNext()) {
                    Map.Entry entry = mapIt.next();
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Integer) {
                        logger.debug("Setting " + key + " to " + (Integer)value);
                        test.setResult(key, "numeric/integer", ((Integer)value).toString());
                        continue;
                    }
                    if (!(value instanceof Float)) continue;
                    test.setResult(key, "numeric/float", ((Float)value).toString());
                }
                test.getJaxorContext().commit();
            }
        }
        catch (Exception e) {
            logger.error("Caught exception updating results.", e);
        }
    }

    public void execute(Project project, Properties properties) throws Exception {
        String SubmissionId = properties.getProperty("SubmissionId");
        Connection connection = project.getConnection();
        logger.debug("Starting DynamicAnalysis Summary for SubmissionId: " + SubmissionId);
        try {
            this.session = new JaxorContextImpl(connection);
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(this.session);
            TestFinderBase testFinder = new TestFinderBase(this.session);
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(SubmissionId));
            TestEntity dynamic = submission.selectTest(".DynamicAnalysis");
            if (dynamic == null) {
                logger.debug(project.getTitle() + ": No DynamicAnalysis info found");
                return;
            }
            this.rollup(dynamic);
            this.session.commit();
            this.session.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            connection.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

