/*
 * Decompiled with CFR 0.152.
 */
package dart.server.wrapimpl;

import dart.server.wrap.ResultList;
import dart.server.wrap.SubmissionBase;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.SubmissionList;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestList;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.mappers.LongMapper;
import net.sourceforge.jaxor.mappers.StringMapper;
import net.sourceforge.jaxor.mappers.TimestampMapper;

public class SubmissionImpl
extends SubmissionBase {
    public TestEntity selectTest(String test) {
        TestFinderBase finder = new TestFinderBase(this.getJaxorContext());
        try {
            return finder.selectByQualifiedNameAndSubmissionId(test, this.getSubmissionId());
        }
        catch (Exception e) {
            return null;
        }
    }

    public TestList selectTestList(String test) {
        TestFinderBase finder = new TestFinderBase(this.getJaxorContext());
        try {
            return finder.selectByQualifiedNameAndSubmissionIdList(test, this.getSubmissionId());
        }
        catch (Exception e) {
            return null;
        }
    }

    public TestList selectRootTestList() {
        TestFinderBase finder = new TestFinderBase(this.getJaxorContext());
        try {
            QueryParams q = new QueryParams();
            q.add(this.getSubmissionId());
            return finder.find("where SubmissionId = ? and ParentTestId is null", q);
        }
        catch (Exception e) {
            return null;
        }
    }

    public TestList selectTestListLike(String test) {
        TestFinderBase finder = new TestFinderBase(this.getJaxorContext());
        try {
            QueryParams q = new QueryParams();
            q.add(new StringMapper(), (Object)test);
            q.add(new LongMapper(), (Object)this.getSubmissionId());
            return finder.find("where qualifiedname like ? and submissionid = ?", q);
        }
        catch (Exception e) {
            return null;
        }
    }

    public SubmissionEntity getNextSubmission() {
        if (this.getNextSubmissionId() == null) {
            return null;
        }
        SubmissionFinderBase finder = new SubmissionFinderBase(this.getJaxorContext());
        return finder.selectBySubmissionId(this.getNextSubmissionId());
    }

    public SubmissionEntity getLastSubmission() {
        if (this.getLastSubmissionId() == null) {
            return null;
        }
        SubmissionFinderBase finder = new SubmissionFinderBase(this.getJaxorContext());
        return finder.selectBySubmissionId(this.getLastSubmissionId());
    }

    public SubmissionList selectLastSubmissions() {
        SubmissionFinderBase finder = new SubmissionFinderBase(this.getJaxorContext());
        try {
            QueryParams q = new QueryParams();
            q.add(this.getClientId());
            q.add(this.getType());
            q.add(new TimestampMapper(), (Object)this.getTimeStamp());
            return finder.find("where clientid = ? and type = ? and timestamp < ? order by timestamp desc", q);
        }
        catch (Exception e) {
            return null;
        }
    }

    public SubmissionList selectNextSubmissions() {
        SubmissionFinderBase finder = new SubmissionFinderBase(this.getJaxorContext());
        try {
            QueryParams q = new QueryParams();
            q.add(this.getClientId());
            q.add(this.getType());
            q.add(new TimestampMapper(), (Object)this.getTimeStamp());
            return finder.find("where clientid = ? and type = ? and timestamp > ? order by timestamp desc", q);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSite() {
        return this.getClientEntity().getSite();
    }

    public String getBuildName() {
        return this.getClientEntity().getBuildName();
    }

    public Integer getNoteCount() {
        try {
            TestList l = this.selectTestList(".Note");
            if (l.size() != 0) {
                return new Integer(l.get(0).selectChildren().size());
            }
            return new Integer(-1);
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    public Integer getUpdateCount() {
        try {
            TestList l = this.selectTestList(".Update.Update");
            if (l.size() == 1) {
                return l.get(0).getPassedSubTests();
            }
            return new Integer(-1);
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    public Boolean hasUpdateCount() {
        try {
            TestList l = this.selectTestList(".Update.Update");
            if (l.size() == 1) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
    }

    public Integer getConfigCount() {
        return new Integer(-1);
    }

    public Boolean hasConfigCount() {
        return new Boolean(false);
    }

    public Integer getErrorCount() {
        try {
            TestList l = this.selectTestList(".Build");
            if (l.size() == 1) {
                Integer count = new Integer(l.get(0).selectResult("ErrorCount").get(0).getValue());
                return count;
            }
            return new Integer(-1);
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    public Boolean hasErrorCount() {
        try {
            TestList l = this.selectTestList(".Build");
            if (l.size() == 1) {
                ResultList lr = l.get(0).selectResult("ErrorCount");
                if (lr.size() != 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            return new Boolean(false);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
    }

    public Integer getWarningCount() {
        try {
            TestList l = this.selectTestList(".Build");
            if (l.size() == 1) {
                Integer count = new Integer(l.get(0).selectResult("WarningCount").get(0).getValue());
                return count;
            }
            return new Integer(-1);
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    public Boolean hasWarningCount() {
        try {
            TestList l = this.selectTestList(".Build");
            if (l.size() == 1) {
                ResultList lr = l.get(0).selectResult("WarningCount");
                if (lr.size() != 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            return new Boolean(false);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
    }

    public Integer getPassedCount() {
        try {
            TestList l = this.selectTestList(".Test");
            if (l.size() == 1) {
                return l.get(0).getPassedSubTests();
            }
            return new Integer(-1);
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    public Boolean hasPassedCount() {
        try {
            TestList l = this.selectTestList(".Test");
            if (l.size() == 1) {
                Integer count = l.get(0).getPassedSubTests();
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
    }

    public Integer getFailedCount() {
        try {
            TestList l = this.selectTestList(".Test");
            if (l.size() == 1) {
                return l.get(0).getFailedSubTests();
            }
            return new Integer(-1);
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    public Boolean hasFailedCount() {
        try {
            TestList l = this.selectTestList(".Test");
            if (l.size() == 1) {
                Integer count = l.get(0).getFailedSubTests();
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
    }

    public Integer getNotRunCount() {
        try {
            TestList l = this.selectTestList(".Test");
            if (l.size() == 1) {
                return l.get(0).getNotRunSubTests();
            }
            return new Integer(-1);
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    public Boolean hasNotRunCount() {
        try {
            TestList l = this.selectTestList(".Test");
            if (l.size() == 1) {
                Integer count = l.get(0).getNotRunSubTests();
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
    }

    public Float getElapsedBuildTime() {
        try {
            TestList l = this.selectTestList(".Build");
            if (l.size() == 1) {
                ResultList lr = l.get(0).selectResult("ElapsedTime");
                if (lr.size() > 0) {
                    return new Float(lr.get(0).getValue());
                }
                return new Float(-1.0);
            }
            return new Float(-1.0);
        }
        catch (Exception e) {
            return new Float(-1.0);
        }
    }

    public Boolean hasElapsedBuildTime() {
        try {
            TestList l = this.selectTestList(".Build");
            if (l.size() == 1) {
                ResultList lr = l.get(0).selectResult("ElapsedTime");
                if (lr.size() > 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            return new Boolean(false);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
    }

    public Float getElapsedTestTime() {
        try {
            TestList l = this.selectTestList(".Test._Properties");
            if (l.size() == 1) {
                ResultList lr = l.get(0).selectResult("ElapsedTime");
                if (lr.size() > 0) {
                    return new Float(lr.get(0).getValue());
                }
                return new Float(-1.0);
            }
            return new Float(-1.0);
        }
        catch (Exception e) {
            return new Float(-1.0);
        }
    }

    public Boolean hasElapsedTestTime() {
        try {
            TestList l = this.selectTestList(".Test._Properties");
            if (l.size() == 1) {
                ResultList lr = l.get(0).selectResult("ElapsedTime");
                if (lr.size() > 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            return new Boolean(false);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
    }
}

