/*
 * Decompiled with CFR 0.152.
 */
package dart.server.wrapimpl;

import dart.server.wrap.ResultEntity;
import dart.server.wrap.ResultFinderBase;
import dart.server.wrap.ResultList;
import dart.server.wrap.TestBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestIterator;
import dart.server.wrap.TestList;
import dart.server.wrapimpl.TestTreeNode;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.mappers.StringMapper;
import org.apache.log4j.Logger;

public class TestImpl
extends TestBase {
    static Logger logger = Logger.getLogger(class$dart$server$wrapimpl$TestImpl == null ? (class$dart$server$wrapimpl$TestImpl = TestImpl.class$("dart.server.wrapimpl.TestImpl")) : class$dart$server$wrapimpl$TestImpl);
    Object defaultResult = null;
    static /* synthetic */ Class class$dart$server$wrapimpl$TestImpl;

    public TestList selectChildren() {
        TestFinderBase finder = new TestFinderBase(this.getJaxorContext());
        QueryParams params = new QueryParams();
        params.add(this.getTestId());
        return finder.find("where ParentTestId=?", params);
    }

    public TestEntity selectParent() {
        TestFinderBase finder = new TestFinderBase(this.getJaxorContext());
        QueryParams params = new QueryParams();
        params.add(this.getParentTestId());
        try {
            return finder.findUnique("where TestId=?", params, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public TestList selectAllChildren() {
        TestList all = new TestList();
        TestList children = this.selectChildren();
        TestIterator it = children.iterator();
        while (it.hasNext()) {
            TestEntity child = it.next();
            TestList grandChildren = child.selectAllChildren();
            all.add(child);
            TestIterator git = grandChildren.iterator();
            while (git.hasNext()) {
                all.add(git.next());
            }
        }
        return all;
    }

    public TestTreeNode getTree(String nodeType) {
        return new TestTreeNode((TestEntity)this, nodeType);
    }

    public String[] splitQualifiedName() {
        return this.getQualifiedName().split("\\.");
    }

    public void setDefaultResultValue(Object r) {
        this.defaultResult = r;
    }

    public Object getDefaultResultValue() {
        return this.defaultResult;
    }

    public void setResult(String name, String type, String value) {
        ResultEntity result;
        ResultFinderBase resultFinder = new ResultFinderBase(this.getJaxorContext());
        ResultList results = this.selectResult(name);
        if (results.toArray().length > 0) {
            result = results.toArray()[0];
        } else {
            result = resultFinder.newInstance();
            result.setTestId(this.getTestId());
            result.setType(type);
            result.setName(name);
        }
        result.setValue(value);
    }

    public ResultList selectResult(String result) {
        logger.debug("selectResult " + result);
        ResultFinderBase finder = new ResultFinderBase(this.getJaxorContext());
        QueryParams params = new QueryParams();
        params.add(new StringMapper(), (Object)result);
        params.add(this.getTestId());
        return finder.find("where name=? and testId=?", params);
    }

    public Object get(String name) {
        logger.debug("get " + name);
        return this.getResultValueAsObject(name, this.defaultResult);
    }

    public String getResultValue(String name, String def) {
        logger.debug("getResultValue " + name + " default: " + def);
        ResultFinderBase finder = new ResultFinderBase(this.getJaxorContext());
        QueryParams params = new QueryParams();
        params.add(new StringMapper(), (Object)name);
        params.add(this.getTestId());
        ResultList list = finder.find("where name=? and testId=?", params);
        if (list.size() == 0) {
            return def;
        }
        return list.get(0).getValue();
    }

    public Object getResultValueAsObject(String name, Object def) {
        logger.debug("getResultValueAsObject " + name + " default " + def);
        ResultFinderBase finder = new ResultFinderBase(this.getJaxorContext());
        QueryParams params = new QueryParams();
        params.add(new StringMapper(), (Object)name);
        params.add(this.getTestId());
        ResultList list = finder.find("where name=? and testId=?", params);
        if (list.size() == 0) {
            return def;
        }
        ResultEntity result = list.get(0);
        String resultType = result.getType();
        if (resultType.equals("numeric/float")) {
            logger.debug("returning numeric/float " + result.getValue());
            return new Float(result.getValue());
        }
        if (resultType.equals("numeric/integer")) {
            logger.debug("returning numeric/integer " + result.getValue());
            return new Integer(result.getValue());
        }
        if (resultType.equals("text/string")) {
            logger.debug("returning text/string " + result.getValue());
            return new String(result.getValue());
        }
        return list.get(0).getValue();
    }

    public Float getExecutionTime() {
        try {
            ResultList l = this.selectResult("Execution Time");
            if (l.size() > 0) {
                return new Float(l.get(0).getValue());
            }
            return new Float(-1.0);
        }
        catch (Exception e) {
            return new Float(-1.0);
        }
    }

    public String getCompletionStatus(String defaultValue) {
        try {
            ResultList l = this.selectResult("Completion Status");
            if (l.size() > 0) {
                return l.get(0).getValue();
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getCompletionStatus() {
        return this.getCompletionStatus("");
    }

    public String getStatusAsString() {
        String status = this.getStatus();
        if (status.equals("p")) {
            return "passed";
        }
        if (status.equals("f")) {
            return "failed";
        }
        if (status.equals("n")) {
            return "notrun";
        }
        if (status.equals("m")) {
            return "meta";
        }
        return "meta";
    }

    public Integer getStatusAsNumber() {
        String status = this.getStatus();
        if (status.equals("p")) {
            return new Integer(1);
        }
        if (status.equals("f")) {
            return new Integer(0);
        }
        if (status.equals("n")) {
            return new Integer(-1);
        }
        if (status.equals("m")) {
            return new Integer(0);
        }
        return new Integer(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

