/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.jaxor.SqlAdapter;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.impl.DeleteEntityChange;
import net.sourceforge.jaxor.impl.InsertEntityChange;
import net.sourceforge.jaxor.impl.UpdateEntityChange;

public abstract class EntityChange
implements Comparable,
Serializable {
    private final int changeNumber;
    private final EntityInterface _entity;
    private final SqlAdapter _sqlAdapter;

    public EntityChange(EntityInterface entity) {
        this(-1, entity);
    }

    public EntityChange(int changeNumber, EntityInterface entity) {
        this.changeNumber = changeNumber;
        this._entity = entity;
        this._sqlAdapter = new SqlAdapter(this._entity);
    }

    public SqlAdapter getSqlAdapter() {
        return this._sqlAdapter;
    }

    public static EntityChange update(int changeNumber, EntityInterface entity) {
        return new UpdateEntityChange(changeNumber, entity);
    }

    public static EntityChange insert(int changeNumber, EntityInterface entity) {
        return new InsertEntityChange(changeNumber, entity);
    }

    public static EntityChange delete(int changeNumber, EntityInterface entity) {
        return new DeleteEntityChange(changeNumber, entity);
    }

    public int compareTo(Object o) {
        EntityChange entityChange = (EntityChange)o;
        if (this.equals(o)) {
            return 0;
        }
        return this.changeNumber - entityChange.changeNumber;
    }

    public boolean equals(Object o) {
        EntityChange entityChange = (EntityChange)o;
        return this.equalClasses(o) && entityChange.getEntity().equals(this.getEntity());
    }

    private boolean equalClasses(Object o) {
        return this.getClass().equals(o.getClass());
    }

    public EntityInterface getEntity() {
        return this._entity;
    }

    public boolean canBatchWithLast(EntityChange last) {
        if (last == null) {
            return false;
        }
        if (!this.isBatchable()) {
            return false;
        }
        if (!this.equalClasses(last)) {
            return false;
        }
        return this.getEntity().getImplementationClass().equals(last.getEntity().getImplementationClass());
    }

    public abstract void beforeFlush();

    public abstract void flush(Connection var1);

    public abstract void afterFlush();

    public abstract PreparedStatement execute(Connection var1) throws SQLException;

    public abstract boolean isBatchable();

    public abstract void addToBatch(PreparedStatement var1) throws SQLException;

    public String toString() {
        return this._entity.toString();
    }

    public void executeSingleChange(Connection connection) {
        this.beforeFlush();
        this.flush(connection);
        this.afterFlush();
    }
}

