/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.MetaField;
import net.sourceforge.jaxor.MetaRow;

public class MetaParser
implements Serializable {
    private final String _insert;
    private final String _update;
    private final String _delete;

    public MetaParser(MetaRow row) {
        this._insert = MetaParser.insertSQL(row);
        this._update = MetaParser.updateSQL(row);
        this._delete = MetaParser.deleteSQL(row);
    }

    public String getInsert() {
        return this._insert;
    }

    public String getUpdate() {
        return this._update;
    }

    public String getDelete() {
        return this._delete;
    }

    private static String insertSQL(MetaRow _meta) {
        StringBuffer sql = new StringBuffer("INSERT INTO " + _meta.getTableName() + "(");
        List insert = _meta.getInsertColumns();
        Iterator itr = insert.iterator();
        while (itr.hasNext()) {
            MetaField attr = (MetaField)itr.next();
            sql.append(attr.getColumn());
            if (!itr.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") VALUES(");
        itr = insert.iterator();
        while (itr.hasNext()) {
            itr.next();
            sql.append("?");
            if (!itr.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    private static String updateSQL(MetaRow _meta) {
        StringBuffer sql = new StringBuffer("UPDATE " + _meta.getTableName() + " SET ");
        List nonKeys = _meta.getUpdateColumns();
        Iterator itr = nonKeys.iterator();
        String attrValues = "";
        while (itr.hasNext()) {
            MetaField attr = (MetaField)itr.next();
            if (attrValues.length() > 0) {
                attrValues = attrValues + ",";
            }
            attrValues = attrValues + attr.getColumn() + " = ?";
        }
        sql.append(attrValues);
        sql.append(" WHERE ");
        List matchList = _meta.getUpdateMatchColumns();
        Iterator iterator = matchList.iterator();
        while (iterator.hasNext()) {
            MetaField attribute = (MetaField)iterator.next();
            String attrName = attribute.getColumn();
            sql.append(attrName);
            sql.append(" = ?");
            if (!iterator.hasNext()) continue;
            sql.append(" AND ");
        }
        return sql.toString();
    }

    private static String deleteSQL(MetaRow _meta) {
        StringBuffer sql = new StringBuffer("DELETE FROM " + _meta.getTableName() + " WHERE ");
        List pk = _meta.getPrimaryKey();
        Iterator iterator = pk.iterator();
        while (iterator.hasNext()) {
            MetaField attribute = (MetaField)iterator.next();
            sql.append(attribute.getColumn());
            sql.append(" = ?");
            if (!iterator.hasNext()) continue;
            sql.append(" AND ");
        }
        return sql.toString();
    }
}

